/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.constants.DefaultClauseInformation;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class NoOpClauseHandler
implements ClauseHandler {
    private final ClauseInformation clauseInformation;
    private final ClauseQueryFactory clauseQueryFactory;
    private final ClauseValidator clauseValidator;
    private final ClausePermissionHandler clausePermissionHandler;
    private final ClauseContextFactory clauseContextFactory;

    public NoOpClauseHandler(ClausePermissionHandler clausePermissionHandler, String fieldId, ClauseNames clauseNames, final String validationI18nKey) {
        this.clausePermissionHandler = clausePermissionHandler;
        this.clauseInformation = new DefaultClauseInformation(fieldId, clauseNames, fieldId, Collections.emptySet(), JiraDataTypes.ALL);
        this.clauseQueryFactory = new ClauseQueryFactory(){

            public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
                return new QueryFactoryResult((Query)new BooleanQuery.Builder().build());
            }
        };
        this.clauseValidator = new ClauseValidator(){

            public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
                MessageSetImpl messages = new MessageSetImpl();
                I18nHelper i18n = NoOpClauseHandler.this.getI18n(searcher);
                messages.addErrorMessage(i18n.getText(validationI18nKey, terminalClause.getName()));
                return messages;
            }
        };
        this.clauseContextFactory = new SimpleClauseContextFactory();
    }

    public ClauseInformation getInformation() {
        return this.clauseInformation;
    }

    public ClauseQueryFactory getFactory() {
        return this.clauseQueryFactory;
    }

    public ClauseValidator getValidator() {
        return this.clauseValidator;
    }

    public ClausePermissionHandler getPermissionHandler() {
        return this.clausePermissionHandler;
    }

    public ClauseContextFactory getClauseContextFactory() {
        return this.clauseContextFactory;
    }

    I18nHelper getI18n(ApplicationUser user) {
        return new I18nBean(user);
    }

    public String toString() {
        return "NoOpClauseHandler";
    }
}

