/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IssueIdClauseContextFactory
implements ClauseContextFactory {
    private static final int BATCH_MAX_SIZE = 1000;
    private final JqlIssueSupport jqlIssueSupport;
    private final JqlOperandResolver jqlOperandResolver;
    private final Set<Operator> supportedOperators;

    IssueIdClauseContextFactory(JqlIssueSupport jqlIssueSupport, JqlOperandResolver jqlOperandResolver, Set<Operator> supportedOperators) {
        this.jqlIssueSupport = jqlIssueSupport;
        this.jqlOperandResolver = jqlOperandResolver;
        this.supportedOperators = supportedOperators;
    }

    private Set<Pair<Long, String>> getProjectIssueTypes(ApplicationUser searcher, List<QueryLiteral> literals) {
        HashSet<Pair<Long, String>> projectIssueTypes = new HashSet<Pair<Long, String>>();
        for (QueryLiteral literal : literals) {
            if (literal.isEmpty()) continue;
            for (Issue issue : this.getIssues(searcher, literal)) {
                projectIssueTypes.add((Pair<Long, String>)Pair.of((Object)issue.getProjectId(), (Object)issue.getIssueTypeId()));
            }
        }
        return projectIssueTypes;
    }

    private Set<Pair<Long, String>> getProjectIssueTypesBatch(ApplicationUser searcher, List<QueryLiteral> literals) {
        try (Ticker ignored = Timers.start((String)"IssueIdClauseContextFactory.getProjectIssueTypesBatch()");){
            HashSet<Long> numericLiterals = new HashSet<Long>();
            HashSet<String> stringLiterals = new HashSet<String>();
            for (QueryLiteral literal : literals) {
                if (literal.isEmpty()) continue;
                if (literal.getLongValue() != null) {
                    numericLiterals.add(literal.getLongValue());
                    continue;
                }
                if (literal.getStringValue() == null) continue;
                stringLiterals.add(literal.getStringValue());
            }
            HashSet<Pair<Long, String>> projectIssueTypes = new HashSet<Pair<Long, String>>();
            if (numericLiterals.size() > 0) {
                projectIssueTypes.addAll(this.jqlIssueSupport.getProjectIssueTypePairsByIds(numericLiterals));
            }
            if (stringLiterals.size() > 0) {
                projectIssueTypes.addAll(this.jqlIssueSupport.getProjectIssueTypePairsByKeys(stringLiterals));
            }
            HashSet<Pair<Long, String>> hashSet = projectIssueTypes;
            return hashSet;
        }
    }

    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        List literals;
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator) || this.isNegationOperator(operator) || this.isEmptyOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        String timerName = "IssueIdClauseContextFactory.getClauseContext()";
        try (Ticker ignored = Timers.start((String)(timerName + " - get literals"));){
            literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        }
        if (literals == null || literals.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ignored = Timers.start((String)(timerName + " - creating context"));
        var7_6 = null;
        try {
            HashSet<ProjectIssueTypeContextImpl> contexts = new HashSet<ProjectIssueTypeContextImpl>();
            int batches = literals.size() / 1000 + 1;
            for (int batchIndex = 0; batchIndex < batches; ++batchIndex) {
                List<QueryLiteral> literalsBatch = literals.subList(batchIndex * 1000, Math.min((batchIndex + 1) * 1000, literals.size()));
                Set<Pair<Long, String>> projectIssueTypes = this.getProjectIssueTypesBatch(searcher, literalsBatch);
                for (Pair<Long, String> projectIssueType : projectIssueTypes) {
                    if (this.isEqualsOperator(operator)) {
                        contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl((Long)projectIssueType.first()), (IssueTypeContext)new IssueTypeContextImpl((String)projectIssueType.second())));
                        continue;
                    }
                    if (!this.isRelationalOperator(operator)) continue;
                    contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl((Long)projectIssueType.first()), (IssueTypeContext)AllIssueTypesContext.INSTANCE));
                }
            }
            ClauseContext clauseContext = contexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(contexts);
            return clauseContext;
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (var7_6 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    private boolean isEmptyOperator(Operator operator) {
        return OperatorClasses.EMPTY_ONLY_OPERATORS.contains(operator);
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private boolean isRelationalOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator);
    }

    private boolean isEqualsOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IN;
    }

    private boolean handlesOperator(Operator operator) {
        return this.supportedOperators.contains(operator);
    }

    private Collection<Issue> getIssues(ApplicationUser searcher, QueryLiteral literal) {
        Issue issue;
        Assertions.notNull((String)"literal", (Object)literal);
        if (literal.getStringValue() != null) {
            issue = this.jqlIssueSupport.getIssue(literal.getStringValue(), searcher);
        } else if (literal.getLongValue() != null) {
            issue = this.jqlIssueSupport.getIssue(literal.getLongValue().longValue(), searcher);
        } else {
            throw new IllegalStateException("Invalid query literal");
        }
        if (issue != null) {
            return Collections.singleton(issue);
        }
        return Collections.emptySet();
    }

    @InjectableComponent
    public static class Factory {
        private final JqlIssueSupport issueSupport;
        private final JqlOperandResolver operandResolver;

        public Factory(JqlIssueSupport issueSupport, JqlOperandResolver operandResolver) {
            this.issueSupport = issueSupport;
            this.operandResolver = operandResolver;
        }

        public IssueIdClauseContextFactory create(Set<Operator> supportedOperators) {
            return new IssueIdClauseContextFactory(this.issueSupport, this.operandResolver, supportedOperators);
        }
    }
}

