/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueSecurityLevelResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonInjectableComponent
public class IssueSecurityLevelClauseContextFactory
implements ClauseContextFactory {
    private static final Logger log = LoggerFactory.getLogger(IssueSecurityLevelClauseContextFactory.class);
    private final JqlOperandResolver jqlOperandResolver;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final ProjectManager projectManager;
    private final IssueSecurityLevelResolver issueSecurityLevelResolver;

    IssueSecurityLevelClauseContextFactory(IssueSecurityLevelResolver issueSecurityLevelResolver, JqlOperandResolver jqlOperandResolver, IssueSecuritySchemeManager issueSecuritySchemeManager, ProjectManager projectManager) {
        this.issueSecurityLevelResolver = (IssueSecurityLevelResolver)Assertions.notNull((String)"issueSecurityLevelResolver", (Object)issueSecurityLevelResolver);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.issueSecuritySchemeManager = (IssueSecuritySchemeManager)Assertions.notNull((String)"issueSecuritySchemeManager", (Object)issueSecuritySchemeManager);
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
    }

    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.isEqualityOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        return this.getContextFromClause(searcher, terminalClause);
    }

    ClauseContext getContextFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        Set<Project> associatedProjects = this.getAssociatedProjectsFromClause(searcher, terminalClause);
        if (associatedProjects.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Set<ProjectIssueTypeContext> contexts = this.getContextsForProjects(associatedProjects);
        return contexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(contexts);
    }

    Set<Project> getAssociatedProjectsFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        List<IssueSecurityLevel> securityLevels = this.getSecurityLevelsFromClause(searcher, terminalClause);
        HashSet<Project> associatedProjects = new HashSet<Project>();
        for (IssueSecurityLevel securityLevel : securityLevels) {
            if (securityLevel == null) continue;
            associatedProjects.addAll(this.getProjectsForSecurityLevel(securityLevel));
        }
        return associatedProjects;
    }

    List<IssueSecurityLevel> getSecurityLevelsFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        List literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        if (literals == null) {
            return Collections.emptyList();
        }
        List<IssueSecurityLevel> levels = this.issueSecurityLevelResolver.getIssueSecurityLevels(searcher, literals);
        if (this.isNegationOperator(terminalClause.getOperator()) && CollectionUtil.contains(levels, (Predicate)Predicates.notNull())) {
            List<IssueSecurityLevel> allLevels = this.issueSecurityLevelResolver.getAllSecurityLevels(searcher);
            allLevels.removeAll(levels);
            return allLevels;
        }
        return levels;
    }

    Collection<Project> getProjectsForSecurityLevel(IssueSecurityLevel securityLevel) {
        Long schemeId = securityLevel.getSchemeId();
        return this.issueSecuritySchemeManager.getProjectsUsingScheme(schemeId.longValue());
    }

    private Set<ProjectIssueTypeContext> getContextsForProjects(Collection<Project> projects) {
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        for (Project project : projects) {
            builder.add((Object)new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(project.getId()), (IssueTypeContext)AllIssueTypesContext.INSTANCE));
        }
        return builder.asMutableSet();
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private boolean isEqualityOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    @InjectableComponent
    public static class Creator {
        private final JqlOperandResolver jqlOperandResolver;
        private final IssueSecuritySchemeManager issueSecuritySchemeManager;
        private final ProjectManager projectManager;
        private final IssueSecurityLevelResolver issueSecurityLevelResolver;

        public Creator(IssueSecurityLevelResolver issueSecurityLevelResolver, JqlOperandResolver jqlOperandResolver, IssueSecuritySchemeManager issueSecuritySchemeManager, ProjectManager projectManager) {
            this.issueSecurityLevelResolver = (IssueSecurityLevelResolver)Assertions.notNull((String)"issueSecurityLevelResolver", (Object)issueSecurityLevelResolver);
            this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
            this.issueSecuritySchemeManager = (IssueSecuritySchemeManager)Assertions.notNull((String)"issueSecuritySchemeManager", (Object)issueSecuritySchemeManager);
            this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
        }

        public IssueSecurityLevelClauseContextFactory create() {
            return new IssueSecurityLevelClauseContextFactory(this.issueSecurityLevelResolver, this.jqlOperandResolver, this.issueSecuritySchemeManager, this.projectManager);
        }
    }
}

