/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectClauseContextFactory
implements ClauseContextFactory {
    private final NameResolver<Project> projectResolver;
    private final PermissionManager permissionManager;
    private final ProjectIndexInfoResolver projectIndexInfoResolver;
    private final JqlOperandResolver jqlOperandResolver;

    public ProjectClauseContextFactory(JqlOperandResolver jqlOperandResolver, NameResolver<Project> projectResolver, PermissionManager permissionManager) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.projectResolver = projectResolver;
        this.permissionManager = permissionManager;
        this.projectIndexInfoResolver = new ProjectIndexInfoResolver(projectResolver);
    }

    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List values = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        Set<Project> projectsInContext = this.getProjectsInContext(values, searcher, this.isNegationOperator(operator));
        if (projectsInContext.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        return new ClauseContextImpl(projectsInContext.stream().map(project -> new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(project.getId()), (IssueTypeContext)AllIssueTypesContext.INSTANCE)).collect(Collectors.toSet()));
    }

    private Set<Project> getProjectsInContext(List<QueryLiteral> values, ApplicationUser searcher, boolean negationOperator) {
        Set<Long> projectsInQuery = this.asProjectIds(values);
        if (projectsInQuery.isEmpty()) {
            return Collections.emptySet();
        }
        if (negationOperator) {
            return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, searcher).stream().filter(p -> !projectsInQuery.contains(p.getId())).collect(Collectors.toSet());
        }
        return projectsInQuery.stream().map(arg_0 -> this.projectResolver.get(arg_0)).filter(proj -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, proj, searcher)).collect(Collectors.toSet());
    }

    private Set<Long> asProjectIds(List<QueryLiteral> values) {
        if (values == null) {
            return Collections.emptySet();
        }
        return values.stream().flatMap(value -> {
            if (value.getStringValue() != null) {
                return this.projectIndexInfoResolver.getIndexedValues(value.getStringValue()).stream();
            }
            if (value.getLongValue() != null) {
                return this.projectIndexInfoResolver.getIndexedValues(value.getLongValue()).stream();
            }
            if (value.isEmpty()) {
                return Stream.of(new String[0]);
            }
            throw new IllegalStateException("Invalid query literal");
        }).map(Long::parseLong).collect(Collectors.toSet());
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }
}

