/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.issue.index.indexers.impl.IssueLinkIndexer;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IssueLinkTypesIndexInfoResolver
implements IndexInfoResolver<IssueLinkType> {
    private final IssueLinkTypeManager issueLinkTypeManager;

    public IssueLinkTypesIndexInfoResolver(IssueLinkTypeManager issueLinkTypeManager) {
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    public List<String> getIndexedValues(String rawValue) {
        return Stream.of(this.issueLinkTypeManager.getIssueLinkTypesByOutwardDescription(rawValue).stream().map(linkType -> IssueLinkIndexer.createValue(linkType.getId(), Direction.OUT)), this.issueLinkTypeManager.getIssueLinkTypesByInwardDescription(rawValue).stream().map(linkType -> IssueLinkIndexer.createValue(linkType.getId(), Direction.IN))).flatMap(links -> links).collect(Collectors.toList());
    }

    public List<String> getIndexedValues(Long rawValue) {
        return Optional.ofNullable(this.issueLinkTypeManager.getIssueLinkType(rawValue)).map(type -> Collections.singletonList(this.getIndexedValue((IssueLinkType)type))).orElse(Collections.emptyList());
    }

    public String getIndexedValue(IssueLinkType indexedObject) {
        return IssueLinkIndexer.createValue(indexedObject.getId());
    }
}

