/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.List;

public class ProjectIndexInfoResolver
implements IndexInfoResolver<Project> {
    private final NameResolver<Project> nameResolver;

    public ProjectIndexInfoResolver(NameResolver<Project> nameResolver) {
        this.nameResolver = (NameResolver)Assertions.notNull((String)"nameResolver", nameResolver);
    }

    public List<String> getIndexedValues(String rawValue) {
        Project project;
        Long projId;
        Assertions.notNull((String)"rawValue", (Object)rawValue);
        List projects = this.nameResolver.getIdsFromName(rawValue);
        if (projects.isEmpty() && (projId = this.getValueAsLong(rawValue)) != null && (project = (Project)this.nameResolver.get(projId)) != null) {
            return Collections.singletonList(project.getId().toString());
        }
        return projects;
    }

    public List<String> getIndexedValues(Long rawValue) {
        Assertions.notNull((String)"rawValue", (Object)rawValue);
        Project project = (Project)this.nameResolver.get(rawValue);
        if (project == null) {
            return this.nameResolver.getIdsFromName(rawValue.toString());
        }
        return CollectionBuilder.newBuilder((Object[])new String[]{project.getId().toString()}).asList();
    }

    public String getIndexedValue(Project project) {
        Assertions.notNull((String)"project", (Object)project);
        return project.getId().toString();
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

