/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ComponentIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ComponentResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.ComponentValuesExistValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.jql.validator.ValuesExistValidator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;

public class ComponentValidator
implements ClauseValidator {
    private final ValuesExistValidator componentValuesExistValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final I18nHelper.BeanFactory beanFactory;

    public ComponentValidator(ComponentResolver componentResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, ProjectComponentManager projectComponentManager, ProjectManager projectManager, I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.componentValuesExistValidator = this.getValuesValidator(componentResolver, operandResolver, permissionManager, projectComponentManager, projectManager);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            errors = this.componentValuesExistValidator.validate(searcher, terminalClause);
        }
        return errors;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY});
    }

    ValuesExistValidator getValuesValidator(ComponentResolver componentResolver, JqlOperandResolver operandResolver, PermissionManager permissionManager, ProjectComponentManager projectComponentManager, ProjectManager projectManager) {
        return new ComponentValuesExistValidator(operandResolver, new ComponentIndexInfoResolver(componentResolver), permissionManager, projectComponentManager, projectManager, this.beanFactory);
    }
}

