/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.PredicateOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.HistoryFieldValueValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.history.AndHistoryPredicate;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.history.TerminalHistoryPredicate;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;

public class HistoryPredicateValidator {
    private final PredicateOperandResolver predicateOperandResolver;
    private final JqlDateSupport jqlDateSupport;
    private final JiraAuthenticationContext authContext;
    private final HistoryFieldValueValidator historyFieldValueValidator;
    private final JqlFunctionHandlerRegistry handlerRegistry;
    private final UserManager userManager;

    public HistoryPredicateValidator(JiraAuthenticationContext authContext, PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, HistoryFieldValueValidator historyFieldValueValidator, JqlFunctionHandlerRegistry handlerRegistry, UserManager userManager) {
        this.authContext = authContext;
        this.predicateOperandResolver = predicateOperandResolver;
        this.jqlDateSupport = jqlDateSupport;
        this.historyFieldValueValidator = historyFieldValueValidator;
        this.handlerRegistry = handlerRegistry;
        this.userManager = userManager;
    }

    public MessageSet validate(ApplicationUser searcher, WasClause clause, HistoryPredicate predicate) {
        return this.validate(predicate, clause.getField(), searcher);
    }

    public MessageSet validate(ApplicationUser searcher, ChangedClause clause, HistoryPredicate predicate) {
        return this.validate(predicate, clause.getField(), searcher);
    }

    private MessageSet validate(HistoryPredicate predicate, String fieldName, ApplicationUser searcher) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (predicate instanceof AndHistoryPredicate) {
            for (HistoryPredicate historyPredicate : ((AndHistoryPredicate)predicate).getPredicates()) {
                this.validateTerminalPredicate(searcher, (MessageSet)messageSet, (TerminalHistoryPredicate)historyPredicate, fieldName);
            }
        } else {
            this.validateTerminalPredicate(searcher, (MessageSet)messageSet, (TerminalHistoryPredicate)predicate, fieldName);
        }
        return messageSet;
    }

    private void validateTerminalPredicate(ApplicationUser searcher, MessageSet messageSet, TerminalHistoryPredicate predicate, String fieldName) {
        Operand operand = predicate.getOperand();
        if (this.predicateOperandResolver.isEmptyOperand(searcher, fieldName, operand)) {
            return;
        }
        if (this.predicateOperandResolver.isFunctionOperand(searcher, fieldName, operand)) {
            MessageSet validationMessageSet = this.validateFunctionOperand(searcher, (FunctionOperand)operand, predicate.getOperator(), fieldName);
            messageSet.addMessageSet(validationMessageSet);
            if (validationMessageSet.hasAnyErrors()) {
                return;
            }
        }
        List<QueryLiteral> values = this.predicateOperandResolver.getValues(searcher, fieldName, operand);
        if (predicate.getOperator().equals((Object)Operator.BY)) {
            messageSet.addMessageSet(this.validateUsers(searcher, fieldName, Operator.BY.getDisplayString(), values));
        }
        if (OperatorClasses.CHANGE_HISTORY_DATE_PREDICATES.contains(predicate.getOperator())) {
            messageSet.addMessageSet(this.validateDatePredicates(searcher, predicate, fieldName, values));
        }
        if (OperatorClasses.CHANGE_HISTORY_VALUE_PREDICATES.contains(predicate.getOperator())) {
            messageSet.addMessageSet(this.historyFieldValueValidator.validateValues(searcher, fieldName, values));
        }
    }

    private MessageSet validateDatePredicates(ApplicationUser searcher, TerminalHistoryPredicate predicate, String fieldName, List<QueryLiteral> values) {
        I18nHelper i18nHelper = this.authContext.getI18nHelper();
        MessageSetImpl messageSet = new MessageSetImpl();
        if (predicate.getOperator().equals((Object)Operator.DURING) && values.size() != 2) {
            messageSet.addErrorMessage(i18nHelper.getText("jira.jql.predicate.during.length.invalid.func"));
        }
        if (predicate.getOperator().equals((Object)Operator.AFTER) && values.size() != 1) {
            messageSet.addErrorMessage(i18nHelper.getText("jira.jql.predicate.after.length.invalid.func"));
        }
        if (predicate.getOperator().equals((Object)Operator.BEFORE) && values.size() != 1) {
            messageSet.addErrorMessage(i18nHelper.getText("jira.jql.predicate.before.length.invalid.func"));
        }
        for (QueryLiteral value : values) {
            String str = value.getStringValue();
            if (str == null || this.jqlDateSupport.validate(str)) continue;
            if (this.predicateOperandResolver.isFunctionOperand(searcher, fieldName, value.getSourceOperand())) {
                messageSet.addErrorMessage(i18nHelper.getText("jira.jql.predicate.date.format.invalid.from.func", predicate.getOperator().getDisplayString(), value.getSourceOperand().getName()));
                continue;
            }
            messageSet.addErrorMessage(i18nHelper.getText("jira.jql.predicate.date.format.invalid", str, predicate.getOperator().getDisplayString()));
        }
        return messageSet;
    }

    private MessageSet validateUsers(ApplicationUser searcher, String fieldName, String predicateName, List<QueryLiteral> values) {
        MessageSetImpl messageSet = new MessageSetImpl();
        for (QueryLiteral rawValue : values) {
            String value;
            if (rawValue.getStringValue() != null) {
                if (this.userExists(rawValue.getStringValue())) continue;
                this.addInvalidUserMessage((MessageSet)messageSet, searcher, fieldName, predicateName, rawValue.getSourceOperand(), rawValue.getStringValue());
                continue;
            }
            if (rawValue.getLongValue() == null || this.userExists(value = rawValue.getLongValue().toString())) continue;
            this.addInvalidUserMessage((MessageSet)messageSet, searcher, fieldName, predicateName, rawValue.getSourceOperand(), value);
        }
        return messageSet;
    }

    private void addInvalidUserMessage(MessageSet messageSet, ApplicationUser searcher, String fieldName, String predicateName, Operand operand, String rawValue) {
        I18nHelper i18nHelper = this.authContext.getI18nHelper();
        if (this.predicateOperandResolver.isFunctionOperand(searcher, fieldName, operand)) {
            messageSet.addErrorMessage(i18nHelper.getText("jira.jql.predicate.by.no.value.for.name.from.function", operand.getName(), predicateName));
        } else {
            messageSet.addErrorMessage(i18nHelper.getText("jira.jql.predicate.by.no.value.for.name", rawValue));
        }
    }

    private MessageSet validateFunctionOperand(ApplicationUser searcher, FunctionOperand operand, Operator operator, String fieldName) {
        MessageSetImpl messageSet;
        FunctionOperandHandler handler = this.handlerRegistry.getOperandHandler(operand);
        if (handler == null) {
            messageSet = new MessageSetImpl();
            I18nHelper i18nHelper = this.authContext.getI18nHelper();
            messageSet.addErrorMessage(i18nHelper.getText("jira.jql.operand.illegal.function", operand.getDisplayString()));
        } else {
            TerminalClauseImpl clause = new TerminalClauseImpl(fieldName, operator, (Operand)operand);
            messageSet = handler.validate(searcher, operand, (TerminalClause)clause);
        }
        return messageSet;
    }

    private boolean userExists(String name) {
        return this.userManager.getUserByName(name) != null;
    }
}

