/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.comparator.LocaleSensitiveStringComparator;
import com.atlassian.jira.jql.util.TerminologyJqlAutocompleteAliasProvider;
import com.atlassian.jira.jql.values.AbstractIssueConstantValuesGenerator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class IssueTypeClauseValuesGenerator
extends AbstractIssueConstantValuesGenerator {
    private final ConstantsManager constantsManager;
    private final TerminologyJqlAutocompleteAliasProvider terminologyAliasProvider;

    public IssueTypeClauseValuesGenerator(ConstantsManager constantsManager, TerminologyJqlAutocompleteAliasProvider terminologyAliasProvider) {
        this.terminologyAliasProvider = terminologyAliasProvider;
        this.constantsManager = constantsManager;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        List<IssueConstant> constants = this.getAllConstants();
        ArrayList suggestions = Lists.newArrayList();
        for (IssueConstant constant : constants) {
            suggestions.add(new ClauseValuesGenerator.Result(constant.getName()));
            Optional<String> terminologyAlias = this.terminologyAliasProvider.getAliasForIssueConstant(constant);
            terminologyAlias.ifPresent(alias -> suggestions.add(new ClauseValuesGenerator.Result(constant.getName(), alias)));
        }
        LocaleSensitiveStringComparator localeSensitiveStringComparator = new LocaleSensitiveStringComparator(this.getLocale(searcher));
        List applicableSuggestions = suggestions.stream().filter(result -> StringUtils.isEmpty((CharSequence)valuePrefix) || result.getDisplayNameParts()[0].toLowerCase().startsWith(valuePrefix.toLowerCase())).sorted((o1, o2) -> localeSensitiveStringComparator.compare(o1.getDisplayNameParts()[0], o2.getDisplayNameParts()[0])).limit(maxNumResults).collect(Collectors.toList());
        return new ClauseValuesGenerator.Results(applicableSuggestions);
    }

    @Override
    protected List<IssueConstant> getAllConstants() {
        return new ArrayList<IssueConstant>(this.constantsManager.getAllIssueTypeObjects());
    }
}

