/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LabelsClauseValuesGenerator
implements ClauseValuesGenerator {
    private final LabelManager labelManager;

    public LabelsClauseValuesGenerator(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser user, String jqlClauseName, String valuePrefix, int maxNumResults) {
        return new ClauseValuesGenerator.Results(this.getSearchHandlerManager().getFieldIds(user, jqlClauseName).stream().flatMap(fieldId -> this.getSuggestionsByFieldId((String)fieldId, valuePrefix, user)).limit(maxNumResults).map(ClauseValuesGenerator.Result::new).collect(Collectors.toList()));
    }

    private Stream<String> getSuggestionsByFieldId(String fieldId, String valuePrefix, ApplicationUser user) {
        if (this.isCustomField(fieldId)) {
            return this.labelManager.getSuggestedLabels(user, null, CustomFieldUtils.getCustomFieldId((String)fieldId), valuePrefix).stream();
        }
        return this.labelManager.getSuggestedLabels(user, null, valuePrefix).stream();
    }

    private boolean isCustomField(String fieldId) {
        return !fieldId.equals(SystemSearchConstants.forLabels().getFieldId());
    }

    SearchHandlerManager getSearchHandlerManager() {
        return (SearchHandlerManager)ComponentAccessor.getComponentOfType(SearchHandlerManager.class);
    }
}

