/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.botocss.Botocss;
import com.atlassian.botocss.BotocssStyles;
import com.atlassian.jira.mail.CssInliner;
import com.atlassian.jira.template.CachingJiraHomeTemplateContentLoader;
import com.atlassian.jira.template.CustomTemplatesFeatureAvailabilityCheck;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotoCssInliner
implements CssInliner {
    private static final Logger logger = LoggerFactory.getLogger(BotoCssInliner.class);
    static final int EXPIRE_SECS = 30;
    private final CustomTemplatesFeatureAvailabilityCheck licenseCheck;
    private final CachingJiraHomeTemplateContentLoader jiraHomeTemplateContentLoader;
    private final LoadingCache<Object, BotocssStyles> botocssStyles;
    @VisibleForTesting
    protected final ImmutableList<String> cssFilenames;

    public BotoCssInliner(CustomTemplatesFeatureAvailabilityCheck licenseCheck, CachingJiraHomeTemplateContentLoader jiraHomeTemplateContentLoader) {
        this.licenseCheck = licenseCheck;
        this.jiraHomeTemplateContentLoader = jiraHomeTemplateContentLoader;
        this.cssFilenames = ImmutableList.builder().add((Object)"templates/email/css/aui-styles.css").add((Object)"templates/email/css/all-clients.css").add((Object)"templates/email/css/wiki-renderer.css").add((Object)"templates/email/css/jira-styles.css").add((Object)"templates/email/css/jira-status-lozenges.css").build();
        this.botocssStyles = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).removalListener((RemovalListener)new BotocssRemovalListener()).build((CacheLoader)new BotocssCreator());
    }

    @Override
    public String applyStyles(String html) {
        if (html == null) {
            return null;
        }
        return Botocss.inject((String)html, (BotocssStyles)((BotocssStyles)this.botocssStyles.getUnchecked((Object)this)));
    }

    void performCacheMaintenance() {
        this.botocssStyles.cleanUp();
    }

    private BotocssStyles createStyles() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String filename : this.cssFilenames) {
            if (this.isFeatureEnabled()) {
                stringBuilder.append(this.jiraHomeTemplateContentLoader.getCssContent(filename).orElseGet(() -> {
                    logger.warn("Couldn't find {}, will use default css instead.", (Object)filename);
                    return this.loadCssFromResource(filename);
                }));
                continue;
            }
            stringBuilder.append(this.loadCssFromResource(filename));
        }
        return BotocssStyles.parse((String[])new String[]{stringBuilder.toString()});
    }

    private boolean isFeatureEnabled() {
        return this.licenseCheck.isLicensedForCustomEmailTemplates();
    }

    private String loadCssFromResource(String filename) {
        String string;
        InputStream stream = null;
        try {
            stream = (InputStream)Preconditions.checkNotNull((Object)this.getClass().getClassLoader().getResourceAsStream(filename));
            string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return string;
    }

    private static class BotocssRemovalListener
    implements RemovalListener<Object, BotocssStyles> {
        private BotocssRemovalListener() {
        }

        public void onRemoval(RemovalNotification<Object, BotocssStyles> notification) {
            logger.trace("Removed styles: {}", notification.getValue());
        }
    }

    private class BotocssCreator
    extends CacheLoader<Object, BotocssStyles> {
        private BotocssCreator() {
        }

        public BotocssStyles load(Object key) throws Exception {
            BotocssStyles styles = BotoCssInliner.this.createStyles();
            logger.trace("Creating new styles: {}", (Object)styles);
            return styles;
        }
    }
}

