/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.util.BaseUrl;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueImpl;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.Queue;

public class JiraMailQueue
implements MailQueue {
    private final MailQueue delegate;
    private final BaseUrl baseUrl;

    public JiraMailQueue(BaseUrl baseUrl) {
        this((MailQueue)new MailQueueImpl(), baseUrl);
    }

    @VisibleForTesting
    JiraMailQueue(MailQueue delegate, BaseUrl baseUrl) {
        this.delegate = delegate;
        this.baseUrl = baseUrl;
    }

    public void sendBuffer() {
        this.baseUrl.runWithStaticBaseUrl(null, nullValue -> {
            this.delegate.sendBuffer();
            return null;
        });
    }

    public void sendBufferBlocking() {
        this.baseUrl.runWithStaticBaseUrl(null, nullValue -> {
            this.delegate.sendBufferBlocking();
            return null;
        });
    }

    public int size() {
        return this.delegate.size();
    }

    public int errorSize() {
        return this.delegate.errorSize();
    }

    public void addItem(MailQueueItem item) {
        this.delegate.addItem(item);
    }

    public void addErrorItem(MailQueueItem item) {
        this.delegate.addErrorItem(item);
    }

    public Queue<MailQueueItem> getQueue() {
        return this.delegate.getQueue();
    }

    public Queue<MailQueueItem> getErrorQueue() {
        return this.delegate.getErrorQueue();
    }

    public boolean isSending() {
        return this.delegate.isSending();
    }

    public Timestamp getSendingStarted() {
        return this.delegate.getSendingStarted();
    }

    public Timestamp getLastSendingAttempt() {
        return this.delegate.getLastSendingAttempt();
    }

    public void emptyErrorQueue() {
        this.delegate.emptyErrorQueue();
    }

    public void resendErrorQueue() {
        this.delegate.resendErrorQueue();
    }

    public MailQueueItem getItemBeingSent() {
        return this.delegate.getItemBeingSent();
    }

    public void unstickQueue() {
        this.delegate.unstickQueue();
    }
}

