/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.mail.EmailQueueFlushedEvent;
import com.atlassian.jira.mail.MailQueueManager;
import com.atlassian.mail.queue.MailQueue;
import javax.inject.Inject;

public class MailQueueManagerImpl
implements MailQueueManager {
    private final MailQueue queue;
    private final EventPublisher eventPublisher;

    @Inject
    public MailQueueManagerImpl(MailQueue queue, EventPublisher eventPublisher) {
        this.queue = queue;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public MailQueue getMailQueue() {
        return this.queue;
    }

    @Override
    public void flush() {
        this.eventPublisher.publish((Object)new EmailQueueFlushedEvent(this.queue));
        this.queue.sendBuffer();
    }

    @Override
    public void resendError() {
        this.queue.resendErrorQueue();
    }

    @Override
    public void emptyError() {
        this.queue.emptyErrorQueue();
    }

    @Override
    public void unstick() {
        this.queue.unstickQueue();
    }
}

