/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention.commands;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.issue.MentionIssueEvent;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.mail.MentionMailQueueItem;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.google.common.collect.Maps;
import java.util.HashMap;

@EventComponent
public class EmailMentionedUsers {
    public static final String RECIPIENT_USER_NAME = "recipientUserName";
    private final MailQueue mailQueue;
    private final RendererManager rendererManager;
    private final MailServerManager mailServerManager;

    public EmailMentionedUsers(MailQueue mailQueue, RendererManager rendererManager, MailServerManager mailServerManager) {
        this.mailQueue = mailQueue;
        this.rendererManager = rendererManager;
        this.mailServerManager = mailServerManager;
    }

    @EventListener
    public void execute(MentionIssueEvent mentionIssueEvent) {
        if (this.mailServerManager.isDefaultSMTPMailServerDefined()) {
            ApplicationUser from = mentionIssueEvent.getFromUser();
            for (NotificationRecipient recipient : mentionIssueEvent.getRecipients()) {
                HashMap params = Maps.newHashMap();
                params.put("comment", mentionIssueEvent.getMentionText());
                params.put("issue", mentionIssueEvent.getIssue());
                params.put(RECIPIENT_USER_NAME, recipient.getUser().getUsername());
                IssueRenderContext issueRenderContext = mentionIssueEvent.getIssue().getIssueRenderContext();
                MentionMailQueueItem item = new MentionMailQueueItem(from, recipient, params, issueRenderContext, this.rendererManager, this.mailQueue);
                this.mailQueue.addItem((MailQueueItem)item);
            }
        }
    }
}

