/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention.stats;

import com.atlassian.jira.mention.stats.UserSearchServiceStats;
import com.atlassian.jira.model.querydsl.SchemePermissionsDTO;
import com.atlassian.jira.model.querydsl.UserDTO;
import com.atlassian.jira.permission.SchemePermissionsDAO;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SchemePermissionsDAOWithStats
implements SchemePermissionsDAO {
    private final SchemePermissionsDAO delegate;
    private final UserSearchServiceStats userSearchServiceStats;

    public SchemePermissionsDAOWithStats(SchemePermissionsDAO delegate, UserSearchServiceStats userSearchServiceStats) {
        this.delegate = delegate;
        this.userSearchServiceStats = userSearchServiceStats;
    }

    @Override
    public Long getPermissionSchemeIdFor(long projectId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Long delegateResult = this.delegate.getPermissionSchemeIdFor(projectId);
            this.userSearchServiceStats.getPermissionSchemeIdFor(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.getPermissionSchemeIdForException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to getPermissionSchemeIdFor; projectId=" + projectId, e);
        }
    }

    @Override
    public List<SchemePermissionsDTO> getSchemePermissions(long schemeId, ProjectPermissionKey projectPermissionKey) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<SchemePermissionsDTO> delegateResult = this.delegate.getSchemePermissions(schemeId, projectPermissionKey);
            this.userSearchServiceStats.getSchemePermissions(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.getSchemePermissionsException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to getSchemePermissions; schemeId=" + schemeId + ", projectPermissionKey=" + projectPermissionKey, e);
        }
    }

    @Override
    public List<String> findGroupsFromTypeGroup(long schemeId, ProjectPermissionKey projectPermissionKey) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<String> delegateResult = this.delegate.findGroupsFromTypeGroup(schemeId, projectPermissionKey);
            this.userSearchServiceStats.findGroupsFromTypeGroup(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findGroupsFromTypeGroupException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findGroupsFromTypeGroup; schemeId=" + schemeId + ", projectPermissionKey=" + projectPermissionKey, e);
        }
    }

    @Override
    public List<String> findGroupsFromTypeProjectRoleGroup(long schemeId, long projectId, ProjectPermissionKey projectPermissionKey) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<String> delegateResult = this.delegate.findGroupsFromTypeProjectRoleGroup(schemeId, projectId, projectPermissionKey);
            this.userSearchServiceStats.findGroupsFromTypeProjectRoleGroup(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findGroupsFromTypeProjectRoleGroupException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findGroupsFromTypeProjectRoleGroup; schemeId=" + schemeId + ", projectId=" + projectId + ", projectPermissionKey=" + projectPermissionKey, e);
        }
    }

    @Override
    public List<String> findGroupsFromGroupCF(long schemeId, long issueId, ProjectPermissionKey projectPermissionKey) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<String> delegateResult = this.delegate.findGroupsFromGroupCF(schemeId, issueId, projectPermissionKey);
            this.userSearchServiceStats.findGroupsFromGroupCF(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findGroupsFromGroupCFException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findGroupsFromGroupCF; schemeId=" + schemeId + ", issueId=" + issueId + ", projectPermissionKey=" + projectPermissionKey, e);
        }
    }

    @Override
    public List<String> findGroupsFromSelectCF(long schemeId, long issueId, ProjectPermissionKey projectPermissionKey) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<String> delegateResult = this.delegate.findGroupsFromSelectCF(schemeId, issueId, projectPermissionKey);
            this.userSearchServiceStats.findGroupsFromSelectCF(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findGroupsFromSelectCFException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findGroupsFromSelectCF; schemeId=" + schemeId + ", issueId=" + issueId + ", projectPermissionKey=" + projectPermissionKey, e);
        }
    }

    @Override
    public List<String> findGroupsFromApplicationRole(long schemeId, ProjectPermissionKey projectPermissionKey) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<String> delegateResult = this.delegate.findGroupsFromApplicationRole(schemeId, projectPermissionKey);
            this.userSearchServiceStats.findGroupsFromApplicationRole(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findGroupsFromApplicationRoleException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findGroupsFromApplicationRole; schemeId=" + schemeId + ", projectPermissionKey=" + projectPermissionKey, e);
        }
    }

    @Override
    public List<UserDTO> findTopUsersFromTypeUser(String userSearchName, long schemeId, ProjectPermissionKey projectPermissionKey, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<UserDTO> delegateResult = this.delegate.findTopUsersFromTypeUser(userSearchName, schemeId, projectPermissionKey, topN);
            this.userSearchServiceStats.findTopUsersFromTypeUser(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findTopUsersFromTypeUserException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findTopUsersFromTypeUser; userSearchName=" + userSearchName + ", schemeId=" + schemeId + ", projectPermissionKey=" + projectPermissionKey + ", topN=" + topN, e);
        }
    }

    @Override
    public List<UserDTO> findTopUsersFromUserCF(String userSearchName, long schemeId, long issueId, ProjectPermissionKey projectPermissionKey, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<UserDTO> delegateResult = this.delegate.findTopUsersFromUserCF(userSearchName, schemeId, issueId, projectPermissionKey, topN);
            this.userSearchServiceStats.findTopUsersFromUserCF(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findTopUsersFromUserCFException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findTopUsersFromUserCF; userSearchName=" + userSearchName + ", schemeId=" + schemeId + ", issueId=" + issueId + ", projectPermissionKey=" + projectPermissionKey + ", topN=" + topN, e);
        }
    }

    @Override
    public List<UserDTO> findTopUsersFromTypeProjectRoleUsers(String userSearchName, long schemeId, long projectId, ProjectPermissionKey projectPermissionKey, int topN) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            List<UserDTO> delegateResult = this.delegate.findTopUsersFromTypeProjectRoleUsers(userSearchName, schemeId, projectId, projectPermissionKey, topN);
            this.userSearchServiceStats.findTopUsersFromTypeProjectRoleUsers(delegateResult.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return delegateResult;
        }
        catch (RuntimeException e) {
            this.userSearchServiceStats.findTopUsersFromTypeProjectRoleUsersException(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new RuntimeException("Failed to findTopUsersFromTypeProjectRoleUsers; userSearchName=" + userSearchName + ", schemeId=" + schemeId + ", projectId=" + projectId + ", projectPermissionKey=" + projectPermissionKey + ", topN=" + topN, e);
        }
    }
}

