/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.log.RateLimitingLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionPoolState;
import org.ofbiz.core.entity.jdbc.interceptors.connection.SQLConnectionInterceptor;

public class ConnectionPoolHealthSqlInterceptor
implements SQLConnectionInterceptor {
    private static final int MAX_STACK_TRACES = 3;
    private static final int MAX_IDLE_TIME = 15;
    public static final String DANGER_ZONE = "jira.db.counter.danger.zone";
    public static final String QUIET = "jira.db.counter.quiet";
    public static final String STRICT_MODE = "jira.db.counter.strict.mode";
    static final RateLimitingLogger LOG = new RateLimitingLogger(ConnectionPoolHealthSqlInterceptor.class, 3, 15){

        @Override
        protected boolean wantFullStackTrace() {
            return ConnectionPoolHealthSqlInterceptor.isStrictMode() || super.wantFullStackTrace();
        }
    };
    private static final ThreadLocal<CountHolder> COUNT_HOLDER = ThreadLocal.withInitial(CountHolder::new);

    public void onConnectionTaken(Connection connection, ConnectionPoolState connectionPoolState) {
        COUNT_HOLDER.get().taken(connectionPoolState);
    }

    public void onConnectionReplaced(Connection connection, ConnectionPoolState connectionPoolState) {
        COUNT_HOLDER.get().replaced(connectionPoolState);
    }

    public void beforeExecution(String sqlString, List<String> parameterValues, Statement statement) {
    }

    public void afterSuccessfulExecution(String sqlString, List<String> parameterValues, Statement statement, ResultSet resultSet, int rowsUpdated) {
    }

    public void onException(String sqlString, List<String> parameterValues, Statement statement, SQLException sqlException) {
    }

    static void reset() {
        COUNT_HOLDER.remove();
    }

    static int getDangerZone() {
        return JiraSystemProperties.getInstance().getInteger(DANGER_ZONE, Integer.valueOf(2));
    }

    static boolean isQuiet() {
        return JiraSystemProperties.getInstance().getBoolean(QUIET);
    }

    static boolean isStrictMode() {
        return JiraSystemProperties.getInstance().getBoolean(STRICT_MODE);
    }

    static class CountHolder {
        private static final long STALE_AFTER = TimeUnit.MINUTES.toNanos(5L);
        private final long staleAfter = System.nanoTime() + STALE_AFTER;
        private int count;
        private int highWaterMark;
        private int lowWaterMark = -1;

        CountHolder() {
        }

        boolean isStale() {
            return System.nanoTime() >= this.staleAfter;
        }

        private boolean isTooManyConnections() {
            return this.count >= 2 && (this.count > 2 || ConnectionPoolHealthSqlInterceptor.isStrictMode());
        }

        private void initOrUpdateLowWaterMark() {
            if (this.lowWaterMark <= 0 || this.lowWaterMark >= this.count) {
                this.lowWaterMark = this.count - 1;
            }
        }

        private boolean isNewLowWaterMark() {
            if (this.lowWaterMark < this.count) {
                return false;
            }
            this.lowWaterMark = this.count - 1;
            return true;
        }

        private boolean isNewHighWaterMark() {
            if (this.count <= this.highWaterMark) {
                return false;
            }
            this.highWaterMark = this.count;
            return true;
        }

        private boolean isDangerZone(ConnectionPoolState state) {
            int maxSize = state.getConnectionPoolInfo().getMaxSize();
            return maxSize > 0 && this.count > 1 && state.getBorrowedCount() + ConnectionPoolHealthSqlInterceptor.getDangerZone() >= maxSize;
        }

        void logWarn(String event, ConnectionPoolState state) {
            if (ConnectionPoolHealthSqlInterceptor.isQuiet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dangerous use of multiple connections: " + event + " => count=" + this.count + "; marks=[" + this.lowWaterMark + '-' + this.highWaterMark + "]; pool=" + state.getBorrowedCount() + '/' + state.getConnectionPoolInfo().getMaxSize());
                }
            } else {
                LOG.warnWithTrace("Dangerous use of multiple connections: " + event + " => count=" + this.count + "; marks=[" + this.lowWaterMark + '-' + this.highWaterMark + "]; pool=" + state.getBorrowedCount() + '/' + state.getConnectionPoolInfo().getMaxSize());
            }
        }

        void taken(ConnectionPoolState state) {
            if (this.isStale()) {
                LOG.debug("taken: discarding stale counter");
                ConnectionPoolHealthSqlInterceptor.reset();
                return;
            }
            ++this.count;
            if (this.isTooManyConnections() && this.isNewHighWaterMark() || this.isDangerZone(state)) {
                this.initOrUpdateLowWaterMark();
                this.logWarn("taken", state);
            }
        }

        void replaced(ConnectionPoolState state) {
            if (this.isStale()) {
                LOG.debug("replaced: discarding stale counter");
                ConnectionPoolHealthSqlInterceptor.reset();
                return;
            }
            this.count = Math.max(0, this.count - 1);
            if (this.isNewLowWaterMark() || this.isDangerZone(state)) {
                this.logWarn("replaced", state);
            }
            if (this.count <= 0) {
                ConnectionPoolHealthSqlInterceptor.reset();
            }
        }

        public String toString() {
            return "CountHolder[stale=" + this.isStale() + ",count=" + this.count + ",highWaterMark=" + this.highWaterMark + ",lowWaterMark=" + this.lowWaterMark + ']';
        }
    }
}

