/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.system.VersionNumber;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageScannerConfiguration
implements PackageScannerConfiguration,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPackageScannerConfiguration.class);
    private final List<String> packageIncludes = CollectionBuilder.newBuilder((Object[])new String[]{"com.atlassian.*", "io.atlassian.*", "com.google.common.*", "javax.*", "net.jcip.*", "org.jfree.*", "org.joda.*", "com.opensymphony.*", "org.apache.*", "org.ofbiz.*", "org.xml.*", "org.w3c.*", "webwork.*", "org.tuckey.web.filters.urlrewrite.*", "org.bouncycastle*", "org.dom4j*", "org.jdom*", "com.perforce*", "org.slf4j*", "org.codehaus.jackson*", "com.thoughtworks.xstream*", "io.atlassian.*", "com.sun.mail.*"}).asList();
    private final List<String> packageExcludes = CollectionBuilder.newBuilder((Object[])new String[]{"com.atlassian.greenhopper", "com.codahale.metrics*", "com.springframework*", "org.springframework*", "com.sun.jersey.*", "javax.ws.*", "org.apache.tomcat.*", "org.apache.catalina.*", "org.apache.jasper.*", "org.apache.coyote.*", "org.apache.naming*", "*..svn*", "com.atlassian.audit.core*", "com.atlassian.audit.jira*"}).asList();
    private final List<String> jarIncludes = CollectionBuilder.newBuilder((Object[])new String[]{"*.jar"}).asList();
    private final List<String> jarExcludes = Collections.emptyList();
    private final String hostVersion;
    private final Map<String, String> packageVersions;
    private static final String BLANK_OSGI_VERSION = "";

    public DefaultPackageScannerConfiguration(BuildUtilsInfo buildUtilsInfo) {
        this.hostVersion = buildUtilsInfo.getVersion();
        String jiraOsgiVersion = DefaultPackageScannerConfiguration.getAsOSGIVersion(this.hostVersion);
        this.packageVersions = MapBuilder.newBuilder().add((Object)"com.atlassian.jira*", (Object)jiraOsgiVersion).add((Object)"com.atlassian.configurable*", (Object)jiraOsgiVersion).add((Object)"com.atlassian.diff*", (Object)jiraOsgiVersion).add((Object)"com.atlassian.query*", (Object)jiraOsgiVersion).add((Object)"com.opensymphony*", (Object)jiraOsgiVersion).add((Object)"org.apache.commons.dbcp*", (Object)"1.4.0").add((Object)"com.atlassian.crowd*", (Object)buildUtilsInfo.getCrowdOsgiVersion()).add((Object)"com.atlassian.core*", (Object)jiraOsgiVersion).add((Object)"com.atlassian.seraph*", (Object)jiraOsgiVersion).add((Object)"org.w3c*", (Object)BLANK_OSGI_VERSION).add((Object)"javax.xml.namespace*", (Object)BLANK_OSGI_VERSION).add((Object)"org.apache.commons.logging*", (Object)"1.1.1").add((Object)"org.apache.log4j*", (Object)"1.2.17").add((Object)"com.atlassian.sal.api.*", (Object)buildUtilsInfo.getSalVersion()).add((Object)"com.atlassian.soy.renderer", (Object)DefaultPackageScannerConfiguration.getAsOSGIVersion(buildUtilsInfo.getBuildProperty("soy.templates.version"))).add((Object)"com.google.common.*", (Object)buildUtilsInfo.getGuavaOsgiVersion()).add((Object)"com.atlassian.web.servlet.api", (Object)buildUtilsInfo.getBuildProperty("atlassian.servlet.api.version")).add((Object)"com.atlassian.audit.*", (Object)buildUtilsInfo.getAuditVersion()).toMap();
    }

    private static String getAsOSGIVersion(String version) {
        return new VersionNumber(version).getOSGIVersion();
    }

    public void start() throws Exception {
        LOGGER.debug("Created package scanner configuration: {}", (Object)this);
    }

    public List<String> getJarIncludes() {
        return this.jarIncludes;
    }

    public List<String> getJarExcludes() {
        return this.jarExcludes;
    }

    public List<String> getPackageIncludes() {
        return this.packageIncludes;
    }

    public List<String> getPackageExcludes() {
        return this.packageExcludes;
    }

    public Map<String, String> getPackageVersions() {
        return this.packageVersions;
    }

    public String getCurrentHostVersion() {
        return this.hostVersion;
    }

    public ServletContext getServletContext() {
        return ServletContextProvider.getServletContext();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

