/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issueview;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.issueview.IssueView;
import com.atlassian.jira.plugin.issueview.IssueViewModuleDescriptor;
import com.atlassian.jira.plugin.issueview.IssueViewURLHandler;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.plugin.webfragment.descriptors.ConditionDescriptorFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import org.dom4j.Element;

public class IssueViewModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<IssueView>
implements IssueViewModuleDescriptor {
    private String fileExtension;
    private String contentType;
    private final IssueViewURLHandler urlHandler;
    private final ConditionDescriptorFactory conditionDescriptorFactory;
    private int order;
    private Condition condition;
    private Element element;

    public IssueViewModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, IssueViewURLHandler urlHandler, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory);
        this.urlHandler = urlHandler;
        this.conditionDescriptorFactory = conditionDescriptorFactory;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.fileExtension = element.attribute("fileExtension").getStringValue();
        this.contentType = element.attribute("contentType").getStringValue();
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
        this.element = element;
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(IssueView.class);
        this.condition = this.conditionDescriptorFactory.retrieveCondition(this.plugin, this.element);
    }

    @Override
    public void disabled() {
        this.condition = null;
        super.disabled();
    }

    public IssueView getIssueView() {
        return (IssueView)this.getModule();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getURLWithoutContextPath(String issueKey) {
        return this.urlHandler.getURLWithoutContextPath(this, issueKey);
    }

    public int getOrder() {
        return this.order;
    }

    public Condition getCondition() {
        return this.condition;
    }
}

