/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.jql.function.AbstractUserBasedFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComponentsLeadByUserFunction
extends AbstractUserBasedFunction {
    public static final String FUNCTION_COMPONENTS_LEAD_BY_USER = "componentsLeadByUser";
    private static final String JIRA_JQL_COMPONENT_NO_SUCH_USER = "jira.jql.component.no.such.user";
    private final PermissionManager permissionManager;
    private final ProjectComponentManager componentManager;

    public ComponentsLeadByUserFunction(PermissionManager permissionManager, ProjectComponentManager componentManager, UserManager userManager, GlobalPermissionManager globalPermissionManager) {
        super(userManager, globalPermissionManager);
        this.permissionManager = permissionManager;
        this.componentManager = (ProjectComponentManager)Assertions.notNull((String)"componentManager", (Object)componentManager);
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.COMPONENT;
    }

    @Override
    protected List<QueryLiteral> getFunctionValuesList(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, ApplicationUser user) {
        return Stream.concat(queryCreationContext.isSecurityOverriden() ? this.getLeadComponents(user).stream() : Stream.empty(), this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, queryCreationContext.getApplicationUser()).stream().map(Project::getProjectComponents).flatMap(Collection::stream).filter(this.isComponentLead(user))).map(component -> new QueryLiteral((Operand)functionOperand, component.getId())).collect(Collectors.toList());
    }

    private Collection<ProjectComponent> getLeadComponents(ApplicationUser user) {
        return this.componentManager.findComponentsByLead(user.getName());
    }

    private Predicate<ProjectComponent> isComponentLead(ApplicationUser user) {
        return component -> user.getKey().equals(component.getLead());
    }

    @Override
    protected String getUserNotFoundMessageKey() {
        return JIRA_JQL_COMPONENT_NO_SUCH_USER;
    }
}

