/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;

public class MembersOfFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_MEMBERSOF = "membersOf";
    private static final int EXPECTED_ARGS = 1;
    private final UserUtil userUtil;
    private final CrowdService crowdService;
    private final GlobalPermissionManager globalPermissionManager;
    private final FeatureManager featureManager;

    public MembersOfFunction(UserUtil userUtil, CrowdService crowdService, GlobalPermissionManager globalPermissionManager, FeatureManager featureManager) {
        this.userUtil = userUtil;
        this.crowdService = crowdService;
        this.globalPermissionManager = globalPermissionManager;
        this.featureManager = featureManager;
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand functionOperand, TerminalClause terminalClause) {
        String groupName;
        Group group;
        MessageSet messages;
        I18nHelper i18n = this.getI18n();
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, searcher)) {
            if (Users.isAnonymous((ApplicationUser)searcher)) {
                if (this.checkForBrowseUsersPermissionForAnonEnabled()) {
                    return this.getMessageForDisallowedAnonymousAccess(i18n);
                }
            } else if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.MEMBERS_OF_IGNORE_BROWSE_USERS_PERMISSION_FOR_LOGGED_USERS)) {
                return this.getMessageForUnauthorizedAccess(i18n);
            }
        }
        if (!(messages = this.validateNumberOfArgs(functionOperand, 1)).hasAnyErrors() && (group = this.getGroupsIgnoreCase(groupName = (String)functionOperand.getArgs().get(0))) == null) {
            messages.addErrorMessage(i18n.getText("jira.jql.group.no.such.group", functionOperand.getName(), groupName));
        }
        return messages;
    }

    private boolean checkForBrowseUsersPermissionForAnonEnabled() {
        return !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.MEMBERS_OF_IGNORE_ANONYMOUS_BROWSE_USERS_PERMISSION);
    }

    protected MessageSet getMessageForDisallowedAnonymousAccess(I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(i18n.getText("jira.jql.function.anonymous.disallowed", this.getFunctionName()));
        return messageSet;
    }

    protected MessageSet getMessageForUnauthorizedAccess(I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(i18n.getText("jira.jql.function.no.browse.users.permission", this.getFunctionName()));
        return messageSet;
    }

    protected boolean isAnonymousAccessAllowed() {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, null);
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        if (!operand.getArgs().isEmpty()) {
            List<Group> groups;
            SortedSet users;
            String groupName = (String)operand.getArgs().get(0);
            Group group = this.getGroupsIgnoreCase(groupName);
            LinkedHashSet<QueryLiteral> usernames = new LinkedHashSet<QueryLiteral>();
            if (group != null && (users = this.userUtil.getAllUsersInGroups(groups = Collections.singletonList(group))) != null) {
                for (ApplicationUser user : users) {
                    usernames.add(new QueryLiteral((Operand)operand, user.getName()));
                }
            }
            return new ArrayList<QueryLiteral>(usernames);
        }
        return Collections.emptyList();
    }

    private Group getGroupsIgnoreCase(String groupName) {
        return this.crowdService.getGroup(groupName);
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.USER;
    }
}

