/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.jql.function.AbstractUserCapabilityFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ProjectsWhereUserHasPermissionFunction
extends AbstractUserCapabilityFunction {
    public static final String FUNCTION_PROJECTS_WHERE_USER_HAS_PERMISSION = "projectsWhereUserHasPermission";
    private static final String JIRA_JQL_PROJECT_NO_SUCH_USER = "jira.jql.project.no.such.user";
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nHelperFactory;

    public ProjectsWhereUserHasPermissionFunction(PermissionManager permissionManager, UserUtil userUtil, I18nHelper.BeanFactory i18nHelperFactory) {
        super(userUtil);
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.i18nHelperFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nHelperFactory", (Object)i18nHelperFactory);
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.PROJECT;
    }

    @Override
    protected MessageSet validateCapability(String permissionName, I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (this.getPermissionByName(permissionName) == null) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.project.no.such.permission", this.getFunctionName(), permissionName));
        }
        return messageSet;
    }

    private ProjectPermission getPermissionByName(String name) {
        I18nHelper i18nHelper = this.i18nHelperFactory.getInstance(Locale.ENGLISH);
        for (ProjectPermission permission : this.permissionManager.getAllProjectPermissions()) {
            String permissionName = i18nHelper.getText(permission.getNameI18nKey());
            if (!permissionName.equalsIgnoreCase(name)) continue;
            return permission;
        }
        return null;
    }

    @Override
    protected List<QueryLiteral> getFunctionValuesList(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, ApplicationUser user, String permissionName) {
        ProjectPermission permission = this.getPermissionByName(permissionName);
        if (permission == null) {
            return Collections.emptyList();
        }
        Collection projects = this.permissionManager.getProjects(new ProjectPermissionKey(permission.getKey()), user);
        ArrayList<QueryLiteral> values = new ArrayList<QueryLiteral>(projects.size());
        for (Project project : projects) {
            if (queryCreationContext.isSecurityOverriden() || !queryCreationContext.isSecurityOverriden() && !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, queryCreationContext.getApplicationUser())) continue;
            values.add(new QueryLiteral((Operand)functionOperand, project.getId()));
        }
        return values;
    }

    @Override
    protected String getUserNotFoundMessageKey() {
        return JIRA_JQL_PROJECT_NO_SUCH_USER;
    }
}

