/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.extras.api.LicenseType;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.i18n.BootstrapJiraAuthenticationContext;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class FooterDataProvider {
    private final String contextPath;
    private final ApplicationProperties applicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private final ClusterManager clusterManager;
    private final ExternalLinkUtil externalLinkUtil;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraLicenseManager licenseManager;
    private final JiraLicenseService jiraLicenseService;

    public static FooterDataProvider getInstance(String contextPath) {
        JiraLicenseService jiraLicenseService = (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
        ExternalLinkUtil externalLinkUtil = (ExternalLinkUtil)ComponentAccessor.getComponent(ExternalLinkUtil.class);
        JiraAuthenticationContext maybeAuthenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
        JiraAuthenticationContext authenticationContext = maybeAuthenticationContext != null ? maybeAuthenticationContext : new BootstrapJiraAuthenticationContext();
        BuildUtilsInfo buildUtilsInfo = (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class);
        JiraLicenseManager jiraLicenseManager = (JiraLicenseManager)ComponentAccessor.getComponent(JiraLicenseManager.class);
        GlobalPermissionManager permissionManager = (GlobalPermissionManager)ComponentAccessor.getComponent(GlobalPermissionManager.class);
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        return new FooterDataProvider(contextPath, jiraLicenseService, externalLinkUtil, authenticationContext, buildUtilsInfo, permissionManager, jiraLicenseManager, applicationProperties, clusterManager);
    }

    @VisibleForTesting
    FooterDataProvider(String contextPath, @Nullable JiraLicenseService jiraLicenseService, @Nullable ExternalLinkUtil externalLinkUtil, JiraAuthenticationContext authenticationContext, @Nullable BuildUtilsInfo buildUtilsInfo, @Nullable GlobalPermissionManager permissionManager, @Nullable JiraLicenseManager licenseManager, @Nullable ApplicationProperties applicationProperties, @Nullable ClusterManager clusterManager) {
        this.contextPath = Objects.requireNonNull(contextPath);
        this.jiraLicenseService = jiraLicenseService;
        this.externalLinkUtil = externalLinkUtil;
        this.authenticationContext = Objects.requireNonNull(authenticationContext);
        this.buildUtilsInfo = buildUtilsInfo;
        this.permissionManager = permissionManager;
        this.licenseManager = licenseManager;
        this.applicationProperties = applicationProperties;
        this.clusterManager = clusterManager;
    }

    @Nonnull
    public JSONObject asJSON() {
        JSONObject footerModel = new JSONObject();
        this.addLicenseInfo(footerModel);
        this.addBuildInfo(footerModel);
        this.addLinks(footerModel);
        return footerModel;
    }

    @Nonnull
    public Map<String, Object> asMap() {
        HashMap<String, Object> footerModel = new HashMap<String, Object>();
        this.addToMap(footerModel);
        return footerModel;
    }

    @Nonnull
    public Map<String, Object> addToMap(Map<String, Object> footerModel) {
        this.addLicenseInfo(footerModel);
        this.addBuildInfo(footerModel);
        this.addLinks(footerModel);
        return footerModel;
    }

    private void addLicenseInfo(Object container) {
        this.getErrorAndLicenseState().ifPresent(licenseSummary -> licenseSummary.addLicenseData(container));
    }

    private void addBuildInfo(Object container) {
        if (this.buildUtilsInfo == null) {
            return;
        }
        FooterDataProvider.addToContainer(container, "buildVersion", this.buildUtilsInfo.getVersion());
        FooterDataProvider.addToContainer(container, "buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        FooterDataProvider.addToContainer(container, "commitId", StringUtils.trimToEmpty((String)this.buildUtilsInfo.getCommitId()));
        FooterDataProvider.addToContainer(container, "nodeId", this.nodeId());
        FooterDataProvider.addToContainer(container, "partnerName", this.buildUtilsInfo.getBuildPartnerName());
    }

    @Nonnull
    private String nodeId() {
        if (this.clusterManager == null) {
            return "";
        }
        return this.clusterManager.isClustered() ? StringUtils.trimToEmpty((String)this.clusterManager.getNodeId()) : "";
    }

    private void addLinks(Object container) {
        FooterDataProvider.addToContainer(container, "linkIssue", this.issueLink());
        FooterDataProvider.addToContainer(container, "linkJira", this.jiraLink());
        FooterDataProvider.addToContainer(container, "linkAbout", this.aboutLink());
    }

    private static void addToContainer(Object container, String key, @Nullable Object val) {
        if (val == null) {
            return;
        }
        if (container instanceof JSONObject) {
            try {
                ((JSONObject)container).put(key, val);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Could not add value to JSON", e);
            }
            return;
        }
        if (container instanceof Map) {
            ((Map)container).put(key, val);
            return;
        }
        throw new IllegalArgumentException("The passed container type is not supported. Type: " + container.getClass().getName());
    }

    @Nonnull
    private Optional<LicenseSummary> getErrorAndLicenseState() {
        if (this.jiraLicenseService == null) {
            return Optional.empty();
        }
        if (!FooterDataProvider.getSafely(() -> ((JiraLicenseService)this.jiraLicenseService).isLicenseSet(), true).booleanValue()) {
            return this.dataForUnlicensed();
        }
        if (this.licenseManager != null) {
            if (FooterDataProvider.getSafely(() -> ((JiraLicenseManager)this.licenseManager).hasLicenseTooOldForBuildConfirmationBeenDone(), false).booleanValue()) {
                return this.dataForTooOldLicense();
            }
        }
        Iterable licenses = FooterDataProvider.getSafely(() -> ((JiraLicenseService)this.jiraLicenseService).getLicenses(), Collections.emptyList());
        String organisation = this.extractOrganisations(licenses);
        return StreamSupport.stream(licenses.spliterator(), false).map(ld -> this.dataByLicenseType((LicenseDetails)ld, organisation)).filter(Objects::nonNull).sorted(FooterDataProvider::sortLicenses).findFirst();
    }

    private static <T> T getSafely(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    @Nonnull
    private LicenseSummary dataForEvaluationLicense() {
        String linkHref = this.externalLink("external.link.jira.product.site", new String[0]);
        String linkHref2 = this.contextPath + "/plugins/servlet/applications/versions-licenses";
        return LicenseSummary.forEvaluators(true, "system.footer.consider.purchsing.license", linkHref, linkHref2);
    }

    @Nonnull
    private Optional<LicenseSummary> dataForUnlicensed() {
        String link = this.getExternalLinkWithVersionBuildNumAndServerId("external.link.jira.license.evaluate.from.unlicensed");
        return Optional.ofNullable(link).map(linkHref -> LicenseSummary.withSingleLink(true, "system.footer.request.evaluation.license", linkHref));
    }

    @Nonnull
    private Optional<LicenseSummary> dataForTooOldLicense() {
        String link = this.getExternalLinkWithVersionBuildNumAndServerId("external.link.jira.license.extend.from.old");
        return Optional.ofNullable(link).map(linkHref -> LicenseSummary.withSingleLink(true, "system.footer.consider.extending.license", linkHref));
    }

    @Nullable
    private String getExternalLinkWithVersionBuildNumAndServerId(String externalLinkKey) {
        if (this.buildUtilsInfo == null || this.jiraLicenseService == null) {
            return null;
        }
        return this.externalLink(externalLinkKey, this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), this.jiraLicenseService.getServerId());
    }

    @Nullable
    private LicenseSummary dataByLicenseType(LicenseDetails licenseDetails, String organisation) {
        if (licenseDetails.isEvaluation()) {
            return this.dataForEvaluationLicense();
        }
        return this.licenseSummaryByLicenseType(licenseDetails.getLicenseType(), organisation);
    }

    @Nullable
    private LicenseSummary licenseSummaryByLicenseType(LicenseType licenseType, String organisation) {
        switch (licenseType) {
            case COMMUNITY: {
                String linkHref = this.externalLink("external.link.jira.product.site", new String[0]);
                return LicenseSummary.forOrganisations(false, "system.footer.free.community.license", organisation, linkHref);
            }
            case DEMONSTRATION: {
                String linkHref = this.getExternalLinkWithVersionBuildNumAndServerId("external.link.jira.license.evaluate.from.unlicensed");
                return LicenseSummary.withSingleLink(false, "system.footer.demonstration.license", linkHref);
            }
            case DEVELOPER: {
                String linkHref = this.getExternalLinkWithVersionBuildNumAndServerId("external.link.jira.product.site");
                return LicenseSummary.withSingleLink(false, "system.footer.developer.license", linkHref);
            }
            case NON_PROFIT: {
                String linkHref = this.externalLink("external.link.jira.product.site", new String[0]);
                return LicenseSummary.forOrganisations(false, "system.footer.non.profit.license", organisation, linkHref);
            }
            case OPEN_SOURCE: {
                String linkHref = this.externalLink("external.link.jira.product.site", new String[0]);
                return LicenseSummary.forOrganisations(false, "system.footer.open.source.license", organisation, linkHref);
            }
            case PERSONAL: {
                String linkHref = this.externalLink("external.link.jira.personal.site", new String[0]);
                return LicenseSummary.withSingleLink(false, "system.footer.personal.license", linkHref);
            }
        }
        return null;
    }

    @Nonnull
    private String extractOrganisations(Iterable<LicenseDetails> licenses) {
        Set organisations = StreamSupport.stream(licenses.spliterator(), false).map(LicenseDetails::getOrganisation).filter(s -> !StringUtils.isBlank((CharSequence)s)).collect(Collectors.toSet());
        return StringUtils.join(organisations, (String)", ");
    }

    private static int sortLicenses(LicenseSummary a, LicenseSummary b) {
        if (a.hasAlert()) {
            return -1;
        }
        if (b.hasAlert()) {
            return 1;
        }
        return 0;
    }

    @Nonnull
    @VisibleForTesting
    String externalLink(String linkKey, String ... params) {
        if (this.externalLinkUtil == null) {
            return "";
        }
        return this.externalLinkUtil.getProperty(linkKey, params);
    }

    @Nonnull
    private String issueLink() {
        if (this.isSysAdmin()) {
            return this.contextPath + "/plugins/servlet/troubleshooting/view/";
        }
        if (this.showForm()) {
            return this.contextPath + "/secure/ContactAdministrators!default.jspa";
        }
        return this.contextPath + "/secure/CreateIssue!default.jspa";
    }

    private boolean showForm() {
        return this.applicationProperties != null && FooterDataProvider.getSafely(() -> this.applicationProperties.getOption("jira.show.contact.administrators.form"), false) != false;
    }

    private boolean isSysAdmin() {
        return this.permissionManager != null && FooterDataProvider.getSafely(() -> this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.authenticationContext.getUser()), false) != false;
    }

    @Nonnull
    private String aboutLink() {
        return this.contextPath + "/secure/AboutPage.jspa";
    }

    @Nonnull
    private String jiraLink() {
        return this.externalLink("external.link.seo.project.management.software", new String[0]);
    }

    static class LicenseSummary {
        private final boolean hasAlert;
        private final int numberOfTranslationParams;
        @Nonnull
        private final String translationKey;
        @Nullable
        private final String linkHref;
        @Nullable
        private final String linkHref2;
        @Nullable
        private final String organisation;

        static LicenseSummary withSingleLink(boolean hasAlert, String translationKey, @Nullable String linkHref) {
            return new LicenseSummary(hasAlert, 2, translationKey, linkHref, null, null);
        }

        static LicenseSummary forOrganisations(boolean hasAlert, String translationKey, String organisation, @Nullable String linkHref) {
            return new LicenseSummary(hasAlert, 7, translationKey, linkHref, null, organisation);
        }

        static LicenseSummary forEvaluators(boolean hasAlert, String translationKey, @Nullable String linkHref, @Nullable String linkHref2) {
            return new LicenseSummary(hasAlert, 4, translationKey, linkHref, linkHref2, null);
        }

        private LicenseSummary(boolean hasAlert, int numberOfTranslationParams, @Nonnull String translationKey, @Nullable String linkHref, @Nullable String linkHref2, @Nullable String organisation) {
            this.hasAlert = hasAlert;
            this.numberOfTranslationParams = numberOfTranslationParams;
            this.translationKey = translationKey;
            this.linkHref = linkHref;
            this.linkHref2 = linkHref2;
            this.organisation = organisation;
        }

        boolean hasAlert() {
            return this.hasAlert;
        }

        void addLicenseData(Object container) {
            if (StringUtils.isBlank((CharSequence)this.linkHref)) {
                return;
            }
            FooterDataProvider.addToContainer(container, "licenseHasAlert", this.hasAlert);
            FooterDataProvider.addToContainer(container, "licenseNumberOfTranslationParams", this.numberOfTranslationParams);
            FooterDataProvider.addToContainer(container, "licenseTranslationKey", this.translationKey);
            FooterDataProvider.addToContainer(container, "licenseLinkHref", this.linkHref);
            FooterDataProvider.addToContainer(container, "licenseLinkHref2", this.linkHref2);
            FooterDataProvider.addToContainer(container, "licenseOrganisation", this.organisation);
        }
    }
}

