/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractDashboardCondition;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;

public class IsDashboardOwnerCondition
extends AbstractDashboardCondition {
    private final FeatureManager featureManager;
    private final GlobalPermissionManager permissionManager;

    public IsDashboardOwnerCondition(FeatureManager featureManager, GlobalPermissionManager permissionManager) {
        this.featureManager = featureManager;
        this.permissionManager = permissionManager;
    }

    @Override
    boolean shouldDisplay(@Nonnull JiraServiceContextImpl jiraServiceContext, PortalPage portalPage) {
        ApplicationUser currentUser = jiraServiceContext.getLoggedInApplicationUser();
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS) && this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return true;
        }
        return currentUser != null && currentUser.equals((Object)portalPage.getOwner());
    }
}

