/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.cache.CacheManager;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.feature.OneWayDatabaseVersionFeature;
import com.atlassian.jira.config.properties.ZDUDbBackedCachedPropertySetManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.project.DefaultProjectPropertiesManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.propertyset.ComponentCachingOfBizPropertyEntryStore;
import com.atlassian.jira.util.Supplier;
import com.opensymphony.module.propertyset.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZDUProjectPropertiesManager
extends DefaultProjectPropertiesManager {
    private static final Logger log = LoggerFactory.getLogger(ZDUProjectPropertiesManager.class);
    private static final String SYSTEM_PROPERTY_SINGLE_CACHE_DISABLED = "com.atlassian.jira.property.set.single.cache.project.disabled";
    private static final int JIRA_VERSION_WITH_FEATURE_ENABLED = 815000;
    private final OneWayDatabaseVersionFeature oneWayDatabaseVersionFeature = new OneWayDatabaseVersionFeature(ZDUProjectPropertiesManager.class.getName(), "com.atlassian.jira.property.set.single.cache.project.disabled", 815000, (Supplier<Integer>)((Supplier)zduDbBackedCachedPropertySetManager::getDatabaseBuildNumber), this::clearCaches);

    public ZDUProjectPropertiesManager(CacheManager cacheManager, QueryDslAccessor queryDslAccessor, EventListenerRegistrar eventListenerRegistrar, ZDUDbBackedCachedPropertySetManager zduDbBackedCachedPropertySetManager) {
        super(cacheManager, queryDslAccessor, eventListenerRegistrar);
    }

    @Override
    public PropertySet getPropertySet(Project project) {
        if (this.oneWayDatabaseVersionFeature.isFeatureEnabled()) {
            return super.getPropertySet(project);
        }
        return OFBizPropertyUtils.getCachingPropertySet(project.getGenericValue());
    }

    @EventListener
    public void onJiraUpgradedEvent(JiraUpgradedEvent jiraUpgradedEvent) {
        this.clearCaches();
    }

    private void clearCaches() {
        log.info("Clearing caches: {}", (Object)ZDUProjectPropertiesManager.class.getSimpleName());
        super.onClearCache(null);
        ComponentAccessor.getComponentSafely(ComponentCachingOfBizPropertyEntryStore.class).ifPresent(cachingOfBizPropertyEntryStore -> cachingOfBizPropertyEntryStore.onClearCache(null));
    }
}

