/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.cache.CacheManager;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.permission.GlobalPermissionAddedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionDeletedEvent;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionEntry;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.GlobalPermissionsCache;
import com.atlassian.jira.security.JiraPermission;
import com.atlassian.jira.security.JiraPermissionImpl;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.plugin.GlobalPermissionTypesManager;
import com.atlassian.jira.security.plugin.ScopesRequestCacheDelegate;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@EventComponent
public class DefaultGlobalPermissionManager
implements GlobalPermissionManager,
GroupConfigurable {
    private static final ImmutableSet<GlobalPermissionKey> ONDEMAND_UM_MANAGED_PERMISSIONS = ImmutableSet.of((Object)GlobalPermissionKey.ADMINISTER, (Object)GlobalPermissionKey.SYSTEM_ADMIN, (Object)GlobalPermissionKey.USE);
    private static final int MAX_REQUEST_CACHE_SIZE = 10;
    private static final Object ONLY_KEY = new Object();
    private final GlobalPermissionsCache globalPermissionsCache;
    private final CrowdService crowdService;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;
    private final GlobalPermissionTypesManager globalPermissionTypesManager;
    private final GroupManager groupManager;
    private final RecoveryMode recoveryMode;
    private final ApplicationRoleManager applicationRoleManager;
    private final FeatureManager featureManager;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final RequestCache<Object, Map<ApplicationUser, Map<GlobalPermissionKey, Boolean>>> requestPermissionsCache;

    public DefaultGlobalPermissionManager(CrowdService crowdService, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, GlobalPermissionTypesManager globalPermissionTypesManager, CacheManager cacheManager, ApplicationRoleManager applicationRoleManager, GroupManager groupManager, RecoveryMode recoveryMode, FeatureManager featureManager, ScopesRequestCacheDelegate scopesRequestCacheDelegate, RequestCacheFactory requestCacheFactory) {
        this.crowdService = crowdService;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
        this.globalPermissionTypesManager = globalPermissionTypesManager;
        this.recoveryMode = (RecoveryMode)Assertions.notNull((String)"recoveryMode", (Object)recoveryMode);
        this.groupManager = groupManager;
        this.globalPermissionsCache = new GlobalPermissionsCache(ofBizDelegator, cacheManager);
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.featureManager = (FeatureManager)Assertions.notNull((String)"featureManager", (Object)featureManager);
        this.scopesRequestCacheDelegate = (ScopesRequestCacheDelegate)Assertions.notNull((String)"oAuth2ScopesDelegate", (Object)scopesRequestCacheDelegate);
        this.requestPermissionsCache = requestCacheFactory.createRequestCache(DefaultGlobalPermissionManager.class + "user.permissions", ignore -> new LinkedHashMap<ApplicationUser, Map<GlobalPermissionKey, Boolean>>(14, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 10;
            }
        });
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches();
    }

    public Collection<GlobalPermissionType> getAllGlobalPermissions() {
        return this.globalPermissionTypesManager.getAll();
    }

    public Option<GlobalPermissionType> getGlobalPermission(int permissionId) {
        GlobalPermissionKey translatedPermissionKey = (GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permissionId);
        if (translatedPermissionKey == null) {
            return Option.none();
        }
        return this.getGlobalPermission(translatedPermissionKey);
    }

    public Option<GlobalPermissionType> getGlobalPermission(@Nonnull String permissionKey) {
        return this.globalPermissionTypesManager.getGlobalPermission(permissionKey);
    }

    public Option<GlobalPermissionType> getGlobalPermission(@Nonnull GlobalPermissionKey permissionKey) {
        return this.globalPermissionTypesManager.getGlobalPermission(permissionKey);
    }

    public boolean addPermission(int permissionId, String group) {
        return (Boolean)this.getGlobalPermission(permissionId).fold(() -> {
            throw new IllegalArgumentException("Permission id passed must be a global permission, " + permissionId + " is not");
        }, globalPermissionType -> this.addPermission((GlobalPermissionType)globalPermissionType, group));
    }

    public boolean addPermission(@Nonnull GlobalPermissionType globalPermissionType, String group) {
        this.ensureUsePermissionNotUsed(globalPermissionType.getGlobalPermissionKey());
        if (!globalPermissionType.isAnonymousAllowed() && group == null) {
            throw new IllegalArgumentException("The group Anyone cannot be added to the global permission JIRA Users");
        }
        this.ofBizDelegator.createValue("GlobalPermissionEntry", (Map)FieldMap.build((String)"permission", (Object)globalPermissionType.getKey()).add("group_id", (Object)group));
        this.clearCaches();
        this.clearActiveUserCountIfNecessary(globalPermissionType.getGlobalPermissionKey());
        this.eventPublisher.publish((Object)new GlobalPermissionAddedEvent(globalPermissionType, group));
        return true;
    }

    public Collection<JiraPermission> getPermissions(int permissionType) {
        this.ensureUsePermissionNotUsed(permissionType);
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionType);
        if (globalPermissionOpt.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<GlobalPermissionEntry> permissionEntries = this.getPermissions(((GlobalPermissionType)globalPermissionOpt.get()).getGlobalPermissionKey());
        ArrayList translatedEntries = Lists.newArrayListWithCapacity((int)permissionEntries.size());
        for (GlobalPermissionEntry permissionEntry : permissionEntries) {
            translatedEntries.add(new JiraPermissionImpl(permissionType, permissionEntry.getGroup(), "group"));
        }
        return translatedEntries;
    }

    public Collection<GlobalPermissionEntry> getPermissions(GlobalPermissionType globalPermissionType) {
        return this.getPermissions(globalPermissionType.getGlobalPermissionKey());
    }

    @Nonnull
    public Collection<GlobalPermissionEntry> getPermissions(@Nonnull GlobalPermissionKey globalPermissionKey) {
        this.ensureUsePermissionNotUsed(globalPermissionKey);
        return this.globalPermissionsCache.getPermissions(globalPermissionKey.getKey());
    }

    public boolean removePermission(int permissionId, String group) {
        this.ensureUsePermissionNotUsed(permissionId);
        return (Boolean)this.getGlobalPermission(permissionId).fold(() -> {
            throw new IllegalArgumentException("Permission id passed must be a global permission, " + permissionId + " is not");
        }, globalPermissionType -> this.removePermission((GlobalPermissionType)globalPermissionType, group));
    }

    public boolean removePermission(GlobalPermissionType globalPermissionType, String group) {
        this.ensureUsePermissionNotUsed(globalPermissionType.getGlobalPermissionKey());
        GlobalPermissionEntry jiraPermission = new GlobalPermissionEntry(globalPermissionType.getKey(), group);
        if (this.hasPermission(jiraPermission)) {
            this.removePermission(jiraPermission);
            this.clearCaches();
            this.clearActiveUserCountIfNecessary(globalPermissionType.getGlobalPermissionKey());
            this.eventPublisher.publish((Object)new GlobalPermissionDeletedEvent(globalPermissionType, group));
            return true;
        }
        return false;
    }

    public boolean removePermissions(@Nonnull String group) {
        Assertions.notNull((String)"group", (Object)group);
        if (this.crowdService.getGroup(group) == null) {
            throw new IllegalArgumentException("Group passed must exist");
        }
        Set<GlobalPermissionEntry> permissions = this.globalPermissionsCache.getPermissions();
        for (GlobalPermissionEntry permission : permissions) {
            if (!group.equals(permission.getGroup())) continue;
            this.removePermission(permission);
            this.clearActiveUserCountIfNecessary(GlobalPermissionKey.of((String)permission.getPermissionKey()));
        }
        this.clearCaches();
        return true;
    }

    private void removePermission(GlobalPermissionEntry permission) {
        this.ofBizDelegator.removeByAnd("GlobalPermissionEntry", (Map)FieldMap.build((String)"permission", (Object)permission.getPermissionKey()).add("group_id", (Object)permission.getGroup()));
    }

    public boolean hasPermission(int permissionId) {
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionId);
        if (globalPermissionOpt.isEmpty()) {
            return false;
        }
        return this.hasPermission(((GlobalPermissionType)globalPermissionOpt.get()).getGlobalPermissionKey(), null);
    }

    public boolean hasPermission(@Nonnull GlobalPermissionType globalPermissionType) {
        return this.hasPermission(new GlobalPermissionEntry(globalPermissionType.getKey()));
    }

    public boolean hasPermission(int permissionId, ApplicationUser user) {
        GlobalPermissionKey globalPermissionKey = (GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)permissionId);
        if (globalPermissionKey == null) {
            return false;
        }
        return this.hasPermission(globalPermissionKey, user);
    }

    public boolean hasPermission(@Nonnull GlobalPermissionKey globalPermissionKey, @Nullable ApplicationUser user) {
        return this.scopesRequestCacheDelegate.hasPermission(globalPermissionKey) && (this.hasPermissionIgnoreRecovery(globalPermissionKey, user) || DefaultGlobalPermissionManager.isRecoveryPermission(globalPermissionKey) && this.recoveryMode.isRecoveryUser(user));
    }

    private void clearCaches() {
        this.globalPermissionsCache.clearCache();
        this.requestPermissionsCache.removeAll();
    }

    private static boolean isRecoveryPermission(@Nonnull GlobalPermissionKey globalPermissionKey) {
        return DefaultGlobalPermissionManager.isAdminPermission(globalPermissionKey) || GlobalPermissionKey.USE.equals((Object)globalPermissionKey);
    }

    private static boolean isAdminPermission(@Nonnull GlobalPermissionKey globalPermissionKey) {
        return GlobalPermissionKey.ADMINISTER.equals((Object)globalPermissionKey) || GlobalPermissionKey.SYSTEM_ADMIN.equals((Object)globalPermissionKey);
    }

    @Nonnull
    private Boolean loadPermissions(@Nonnull GlobalPermissionKey globalPermissionKey, @Nullable ApplicationUser user) {
        if (user == null) {
            return this.hasPermission(new GlobalPermissionEntry(globalPermissionKey.getKey(), null));
        }
        if (!user.isActive()) {
            return false;
        }
        if (GlobalPermissionKey.USE.getKey().equals(globalPermissionKey.getKey())) {
            return this.applicationRoleManager.hasAnyRole(user);
        }
        if (this.hasPermission(new GlobalPermissionEntry(globalPermissionKey.getKey(), null))) {
            return true;
        }
        Collection userGroups = this.groupManager.getGroupNamesForUser(user);
        return Iterables.any((Iterable)userGroups, groupName -> this.hasPermission(new GlobalPermissionEntry(globalPermissionKey.getKey(), groupName)));
    }

    private boolean hasPermissionIgnoreRecovery(@Nonnull GlobalPermissionKey globalPermissionKey, @Nullable ApplicationUser user) {
        Map permissionCache;
        Map userPermissionCache = (Map)this.requestPermissionsCache.get(ONLY_KEY);
        if (!userPermissionCache.containsKey(user)) {
            userPermissionCache.put(user, new HashMap());
        }
        if (!(permissionCache = (Map)userPermissionCache.get(user)).containsKey(globalPermissionKey)) {
            permissionCache.put(globalPermissionKey, this.loadPermissions(globalPermissionKey, user));
        }
        return (Boolean)permissionCache.get(globalPermissionKey);
    }

    public boolean hasPermission(@Nonnull GlobalPermissionType globalPermissionType, @Nullable ApplicationUser user) {
        return this.hasPermission(globalPermissionType.getGlobalPermissionKey(), user);
    }

    public Collection<Group> getGroupsWithPermission(int permissionId) {
        this.ensureUsePermissionNotUsed(permissionId);
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionId);
        if (globalPermissionOpt.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getGroupsWithPermission(((GlobalPermissionType)globalPermissionOpt.get()).getGlobalPermissionKey());
    }

    public Collection<Group> getGroupsWithPermission(@Nonnull GlobalPermissionType globalPermissionType) {
        return this.getGroupsWithPermission(globalPermissionType.getGlobalPermissionKey());
    }

    @Nonnull
    public Collection<Group> getGroupsWithPermission(@Nonnull GlobalPermissionKey permissionKey) {
        this.ensureUsePermissionNotUsed(permissionKey);
        Collection<String> groupNames = this.getGroupNamesWithPermission(permissionKey);
        ArrayList groups = Lists.newArrayListWithCapacity((int)groupNames.size());
        for (String groupName : groupNames) {
            Group group = this.crowdService.getGroup(groupName);
            if (group == null) continue;
            groups.add(group);
        }
        return Collections.unmodifiableCollection(groups);
    }

    @Nonnull
    public Collection<String> getGroupNames(int permissionId) {
        this.ensureUsePermissionNotUsed(permissionId);
        Option<GlobalPermissionType> globalPermissionOpt = this.getGlobalPermission(permissionId);
        if (globalPermissionOpt.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getGroupNamesWithPermission(((GlobalPermissionType)globalPermissionOpt.get()).getGlobalPermissionKey());
    }

    public Collection<String> getGroupNames(@Nonnull GlobalPermissionType globalPermissionType) {
        this.ensureUsePermissionNotUsed(globalPermissionType.getGlobalPermissionKey());
        return this.getGroupNamesWithPermission(globalPermissionType.getGlobalPermissionKey());
    }

    @Nonnull
    public Collection<String> getGroupNamesWithPermission(@Nonnull GlobalPermissionKey permissionKey) {
        this.ensureUsePermissionNotUsed(permissionKey);
        Collection<GlobalPermissionEntry> permissions = this.globalPermissionsCache.getPermissions(permissionKey.getKey());
        return (Collection)permissions.stream().map(GlobalPermissionEntry::getGroup).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
    }

    public boolean isGlobalPermission(int permissionId) {
        return GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.containsKey((Object)permissionId);
    }

    public void clearCache() {
        this.clearCaches();
    }

    public boolean isPermissionManagedByJira(@Nonnull GlobalPermissionKey permissionKey) {
        boolean umManagementEnabled = this.featureManager.isEnabled(CoreFeatures.PERMISSIONS_MANAGED_BY_UM);
        return !umManagementEnabled || !ONDEMAND_UM_MANAGED_PERMISSIONS.contains((Object)permissionKey);
    }

    protected boolean hasPermission(GlobalPermissionEntry permissionEntry) {
        if (!this.scopesRequestCacheDelegate.hasPermission(permissionEntry)) {
            return false;
        }
        if (GlobalPermissionKey.USE.getKey().equals(permissionEntry.getPermissionKey())) {
            return false;
        }
        if (GlobalPermissionKey.ADMINISTER.getKey().equals(permissionEntry.getPermissionKey())) {
            return this.globalPermissionsCache.hasPermission(permissionEntry) || this.globalPermissionsCache.hasPermission(new GlobalPermissionEntry(GlobalPermissionKey.SYSTEM_ADMIN, permissionEntry.getGroup()));
        }
        return this.globalPermissionsCache.hasPermission(permissionEntry);
    }

    private void clearActiveUserCountIfNecessary(GlobalPermissionKey permissionKey) {
        if (permissionKey.equals((Object)GlobalPermissionKey.USE) || permissionKey.equals((Object)GlobalPermissionKey.ADMINISTER) || permissionKey.equals((Object)GlobalPermissionKey.SYSTEM_ADMIN)) {
            ((LicenseCountService)ComponentAccessor.getComponent(LicenseCountService.class)).flush();
        }
    }

    private void ensureUsePermissionNotUsed(int permissionKey) {
        if (permissionKey == 1) {
            this.throwUnsupportedOperationExceptionForUse();
        }
    }

    private void ensureUsePermissionNotUsed(@Nonnull GlobalPermissionKey permissionKey) {
        if (GlobalPermissionKey.USE.getKey().equals(permissionKey.getKey())) {
            this.throwUnsupportedOperationExceptionForUse();
        }
    }

    private void throwUnsupportedOperationExceptionForUse() {
        throw new UnsupportedOperationException("Can't retrieve/add/remove USE permission in JIRA 7.");
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        return this.globalPermissionsCache.isGroupUsed(group);
    }
}

