/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultInternalProjectPermissionHelper
implements InternalProjectPermissionHelper {
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private ProjectService projectService;
    private UserProjectHistoryManager historyManager;

    public DefaultInternalProjectPermissionHelper(PermissionManager permissionManager, ApplicationProperties applicationProperties) {
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public boolean canUserBrowseProject(Project project, ApplicationUser user) {
        return this.isFixEnabled() ? this.hasProjectWideBrowsePermission(project, user) : this.hasGeneralBrowsePermission(project, user);
    }

    @Override
    public boolean hasPermission(ProjectPermissionKey permissionKey, Project project, ApplicationUser user) {
        if (permissionKey.equals((Object)ProjectPermissions.BROWSE_PROJECTS)) {
            return this.canUserBrowseProject(project, user);
        }
        return this.permissionManager.hasPermission(permissionKey, project, user);
    }

    @Override
    public Collection<Project> getBrowsableProjects(ApplicationUser user) {
        return this.isFixEnabled() ? (Collection)this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user).stream().filter(project -> this.hasProjectWideBrowsePermission((Project)project, user)).collect(Collectors.toCollection(ArrayList::new)) : this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
    }

    @Override
    public ServiceOutcome<List<Project>> getBrowsableProjectsForProjectAction(ApplicationUser user) {
        return this.getProjectService().getAllProjectsForAction(user, this.isFixEnabled() ? ProjectAction.VIEW_PROJECT : ProjectAction.VIEW_ISSUES);
    }

    @Override
    public Collection<Project> getBrowsableProjectsInCategory(ApplicationUser user, ProjectCategory projectCategory) {
        return this.isFixEnabled() ? (Collection)this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user, projectCategory).stream().filter(project -> this.hasProjectWideBrowsePermission((Project)project, user)).collect(Collectors.toList()) : this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user, projectCategory);
    }

    @Override
    public List<Project> getBrowsableProjectHistory(ApplicationUser user) {
        return this.getProjectHistoryManager().getProjectHistoryWithPermissionChecks(this.isFixEnabled() ? ProjectAction.VIEW_PROJECT : ProjectAction.VIEW_ISSUES, user);
    }

    private boolean hasProjectWideBrowsePermission(Project project, ApplicationUser user) {
        return this.permissionManager.hasProjectWidePermission(ProjectPermissions.BROWSE_PROJECTS, project, user).equals((Object)ProjectWidePermission.ALL_ISSUES);
    }

    private boolean hasGeneralBrowsePermission(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user);
    }

    private boolean isFixEnabled() {
        return this.applicationProperties.getOption("jira.project.permission.helper.beta.fix.enabled");
    }

    private ProjectService getProjectService() {
        if (this.projectService == null) {
            this.projectService = (ProjectService)ComponentAccessor.getComponent(ProjectService.class);
        }
        return this.projectService;
    }

    private UserProjectHistoryManager getProjectHistoryManager() {
        if (this.historyManager == null) {
            this.historyManager = (UserProjectHistoryManager)ComponentAccessor.getComponent(UserProjectHistoryManager.class);
        }
        return this.historyManager;
    }
}

