/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.MutablePair;

@ClusterSafe(value="This is a thread local cache and only exists for the life of the request.")
class PermissionsCache {
    private final Map<String, Collection<Project>> userToProject = new HashMap<String, Collection<Project>>();
    private final Map<CacheKey, Boolean> userProjectPermissions = new HashMap<CacheKey, Boolean>();

    PermissionsCache() {
    }

    Collection<Project> computeProjectsWithBrowsePermissionIfAbsent(ApplicationUser user, Supplier<Collection<Project>> getUserProjects) {
        return this.userToProject.computeIfAbsent(this.toUserName(user), o -> Collections.unmodifiableCollection((Collection)getUserProjects.get()));
    }

    boolean computePermissionIfAbsent(ApplicationUser user, Project project, Supplier<Boolean> hasPermission) {
        return this.userProjectPermissions.computeIfAbsent(new CacheKey(user, project), ck -> (Boolean)hasPermission.get());
    }

    @Nullable
    private String toUserName(@Nullable ApplicationUser user) {
        return user != null ? user.getUsername() : null;
    }

    private static class CacheKey
    extends MutablePair<ApplicationUser, Project> {
        CacheKey(ApplicationUser user, Project project) {
            super((Object)user, (Object)project);
        }
    }
}

