/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webwork.WebworkPluginSecurityServiceHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.auth.Authorisation;
import com.atlassian.jira.security.auth.AuthorisationManager;
import com.atlassian.jira.security.auth.AuthorisationModuleDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class AuthorisationManagerImpl
implements AuthorisationManager {
    private static final Logger loggerSecurityEvents = LoginLoggers.LOGIN_SECURITY_EVENTS;
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;
    private final WebworkPluginSecurityServiceHelper webworkPluginSecurityServiceHelper;
    private final ApplicationRoleManager applicationRoleManager;
    private final GlobalPermissionManager globalPermissions;

    public AuthorisationManagerImpl(PermissionManager permissionManager, PluginAccessor pluginAccessor, WebworkPluginSecurityServiceHelper webworkPluginSecurityServiceHelper, ApplicationRoleManager applicationRoleManager, GlobalPermissionManager globalPermissions) {
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
        this.webworkPluginSecurityServiceHelper = webworkPluginSecurityServiceHelper;
        this.applicationRoleManager = applicationRoleManager;
        this.globalPermissions = globalPermissions;
    }

    @Override
    public boolean authoriseForLogin(@Nonnull ApplicationUser user, HttpServletRequest httpServletRequest) {
        boolean authorised;
        Authorisation.Decision decision = this.authoriseForLoginViaPlugins(user, httpServletRequest);
        if (decision == Authorisation.Decision.ABSTAIN) {
            decision = this.authoriseForLoginViaJIRA(user);
        }
        if (!(authorised = decision.toBoolean())) {
            loggerSecurityEvents.warn((Object)("The user '" + this.safeUserName(user) + "' is NOT AUTHORIZED to perform to login for this request"));
        }
        return authorised;
    }

    private Authorisation.Decision authoriseForLoginViaPlugins(ApplicationUser user, HttpServletRequest httpServletRequest) {
        if (user != null) {
            for (Authorisation authorisation : this.getAuthorisations()) {
                Authorisation.Decision decision = this.safeRun(authorisation, user, () -> authorisation.authoriseForLogin(user, httpServletRequest));
                if (decision == Authorisation.Decision.ABSTAIN) continue;
                return decision;
            }
        }
        return Authorisation.Decision.ABSTAIN;
    }

    @Override
    public boolean hasUserAccessToJIRA(@Nonnull ApplicationUser applicationUser) {
        return this.authoriseForLoginViaJIRA(applicationUser).toBoolean();
    }

    private Authorisation.Decision authoriseForLoginViaJIRA(ApplicationUser user) {
        return this.applicationRoleManager.hasAnyRole(user) || this.globalPermissions.hasPermission(GlobalPermissionKey.ADMINISTER, user) ? Authorisation.Decision.GRANTED : Authorisation.Decision.DENIED;
    }

    @Override
    public Set<String> getRequiredRoles(HttpServletRequest httpServletRequest) {
        HashSet requiredRoles = Sets.newHashSet(this.webworkPluginSecurityServiceHelper.getRequiredRoles(httpServletRequest));
        for (Authorisation authorisation : this.getAuthorisations()) {
            try {
                Set set = authorisation.getRequiredRoles(httpServletRequest);
                requiredRoles.addAll(this.safeSet(set));
            }
            catch (RuntimeException e) {
                loggerSecurityEvents.error((Object)String.format("Exception thrown by '%s'. The roles will be ignored : %s", authorisation.getClass().getName(), e.getMessage()));
            }
        }
        return requiredRoles;
    }

    @Override
    public boolean authoriseForRole(@Nullable ApplicationUser user, HttpServletRequest httpServletRequest, String role) {
        boolean authorised;
        Authorisation.Decision decision = this.authoriseForRoleViaPlugins(user, httpServletRequest, role);
        if (decision == Authorisation.Decision.ABSTAIN) {
            decision = this.authoriseForRoleViaJIRA(user, role);
        }
        if (!(authorised = decision.toBoolean())) {
            loggerSecurityEvents.warn((Object)("The user '" + this.safeUserName(user) + "' is NOT AUTHORIZED to perform this request"));
        }
        return authorised;
    }

    private Authorisation.Decision authoriseForRoleViaPlugins(final ApplicationUser user, final HttpServletRequest httpServletRequest, final String role) {
        for (final Authorisation authorisation : this.getAuthorisations()) {
            Authorisation.Decision decision = this.safeRun(authorisation, user, new Callable<Authorisation.Decision>(){

                @Override
                public Authorisation.Decision call() throws Exception {
                    return authorisation.authoriseForRole(user, httpServletRequest, role);
                }
            });
            if (decision == Authorisation.Decision.ABSTAIN) continue;
            return decision;
        }
        return Authorisation.Decision.ABSTAIN;
    }

    private List<Authorisation> getAuthorisations() {
        return SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor).forType(AuthorisationModuleDescriptor.class, (moduleDescriptor, module) -> module);
    }

    private Authorisation.Decision authoriseForRoleViaJIRA(ApplicationUser user, String role) {
        int permissionType = Permissions.getType((String)role);
        if (permissionType == -1) {
            return Authorisation.Decision.DENIED;
        }
        return Authorisation.Decision.toDecision((boolean)this.permissionManager.hasPermission(permissionType, user));
    }

    private Authorisation.Decision safeRun(Authorisation authorisation, ApplicationUser user, Callable<Authorisation.Decision> callable) {
        try {
            Authorisation.Decision decision = callable.call();
            if (loggerSecurityEvents.isDebugEnabled()) {
                loggerSecurityEvents.debug((Object)String.format("%s has authorised '%s' as %s", authorisation.getClass().getName(), this.safeUserName(user), decision));
            }
            return decision;
        }
        catch (Exception e) {
            loggerSecurityEvents.error((Object)String.format("Exception thrown by '%s'. The decision will be treated as ABSTAIN : %s", authorisation.getClass().getName(), e.getMessage()));
            return Authorisation.Decision.ABSTAIN;
        }
    }

    private String safeUserName(ApplicationUser user) {
        return user == null ? "anonymous" : user.getUsername();
    }

    private Set<String> safeSet(Set<String> set) {
        return set == null ? Collections.emptySet() : set;
    }
}

