/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.auth.trustedapps.CurrentApplicationStore;
import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultCurrentApplication;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@EventComponent
public class DefaultCurrentApplicationStore
implements CurrentApplicationStore,
Startable {
    public static final String ACCESS_LOCK = DefaultCurrentApplicationStore.class.getName() + ".accessLock";
    private final ApplicationProperties applicationProperties;
    private final CachedReference<Pair<KeyPair, CurrentApplication>> cache;
    private final JiraLicenseService licenseService;
    private final ClusterLockService clusterLockService;
    private ClusterLock accessLock;

    public DefaultCurrentApplicationStore(ApplicationProperties applicationProperties, JiraLicenseService jiraLicenseService, CacheManager cacheManager, ClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.licenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.cache = cacheManager.getCachedReference(this.getClass(), "cache", (Supplier)new Supplier<Pair<KeyPair, CurrentApplication>>(){

            public Pair<KeyPair, CurrentApplication> get() {
                return DefaultCurrentApplicationStore.this.getOrCreateCurrentApplication();
            }
        });
    }

    public void start() throws Exception {
        this.accessLock = this.clusterLockService.getLockForName(ACCESS_LOCK);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.reset();
    }

    @Override
    @SuppressWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="This is a valid unsynchronized getter")
    public CurrentApplication getCurrentApplication() {
        return (CurrentApplication)((Pair)this.cache.get()).second();
    }

    @Override
    public KeyPair getKeyPair() {
        return (KeyPair)((Pair)this.cache.get()).first();
    }

    @Override
    public void setCurrentApplication(String applicationId, KeyPair pair) {
        Assertions.notBlank((String)"applicationId cannot be blank.", (String)applicationId);
        Assertions.notNull((String)"pair cannot be null.", (Object)pair);
        Assertions.notNull((String)"pair.private cannot be null.", (Object)pair.getPrivate());
        Assertions.notNull((String)"pair.public cannot be null.", (Object)pair.getPublic());
        this.accessLock.lock();
        try {
            this.applicationProperties.setText("jira.trustedapp.key.private.data", KeyFactory.encode(pair.getPrivate()));
            this.applicationProperties.setText("jira.trustedapp.key.public.data", KeyFactory.encode(pair.getPublic()));
            this.applicationProperties.setString("jira.trustedapp.uid", applicationId);
            this.cache.reset();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    @Override
    public void setCurrentApplication(String applicationId, String publicKey, String privateKey) {
        Assertions.notBlank((String)"applicationId cannot be blank.", (String)applicationId);
        Assertions.notNull((String)"publicKey cannot be null.", (Object)publicKey);
        Assertions.notNull((String)"privateKey cannot be null.", (Object)privateKey);
        PublicKey publicKeyObj = KeyFactory.getPublicKey(publicKey);
        if (publicKeyObj instanceof KeyFactory.InvalidPublicKey) {
            throw new IllegalArgumentException("publicKey is not a valid public key.", ((KeyFactory.InvalidKey)((Object)publicKeyObj)).getCause());
        }
        PrivateKey privateKeyObj = KeyFactory.getPrivateKey(privateKey);
        if (privateKeyObj instanceof KeyFactory.InvalidPrivateKey) {
            throw new IllegalArgumentException("privateKey is not a valid private key.", ((KeyFactory.InvalidKey)((Object)privateKeyObj)).getCause());
        }
        this.setCurrentApplication(applicationId, new KeyPair(publicKeyObj, privateKeyObj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<KeyPair, CurrentApplication> getOrCreateCurrentApplication() {
        String uid;
        KeyPair keyPair;
        this.accessLock.lock();
        try {
            String privateKeyData = this.applicationProperties.getText("jira.trustedapp.key.private.data");
            String publicKeyData = this.applicationProperties.getText("jira.trustedapp.key.public.data");
            if (StringUtils.isBlank((CharSequence)privateKeyData)) {
                keyPair = DefaultCurrentApplicationStore.generateNewKeyPair();
                this.applicationProperties.setText("jira.trustedapp.key.private.data", KeyFactory.encode(keyPair.getPrivate()));
                this.applicationProperties.setText("jira.trustedapp.key.public.data", KeyFactory.encode(keyPair.getPublic()));
            } else {
                PrivateKey privateKey = KeyFactory.getPrivateKey(privateKeyData);
                PublicKey publicKey = KeyFactory.getPublicKey(publicKeyData);
                keyPair = new KeyPair(publicKey, privateKey);
            }
            uid = this.applicationProperties.getString("jira.trustedapp.uid");
            if (StringUtils.isBlank((CharSequence)uid)) {
                uid = new UIDGenerator().generateUID(this.licenseService);
                this.applicationProperties.setString("jira.trustedapp.uid", uid);
            }
        }
        finally {
            this.accessLock.unlock();
        }
        DefaultCurrentApplication application = new DefaultCurrentApplication(keyPair.getPublic(), keyPair.getPrivate(), uid);
        return Pair.of((Object)keyPair, (Object)application);
    }

    private static KeyPair generateNewKeyPair() {
        try {
            return KeyFactory.getEncryptionProvider().generateNewKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UIDGenerator {
        SecureRandomService secureRandom = DefaultSecureRandomService.getInstance();

        private UIDGenerator() {
        }

        String generateUID(JiraLicenseService jiraLicenseService) {
            String serverId = jiraLicenseService.getServerId();
            serverId = serverId != null ? serverId : String.valueOf(this.secureRandom.nextLong());
            byte[] idHash = ArrayUtils.subarray((byte[])DigestUtils.md5((String)serverId), (int)0, (int)3);
            return "jira:" + new BigInteger(1, idHash).intValue();
        }
    }

    private static final class Keys {
        private static final String PRIVATE_KEY_DATA = "jira.trustedapp.key.private.data";
        private static final String PUBLIC_KEY_DATA = "jira.trustedapp.key.public.data";
        private static final String UID = "jira.trustedapp.uid";

        private Keys() {
        }
    }
}

