/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GroupDropdown
extends AbstractProjectsSecurityType {
    public static final String DESC = "group";
    private static final UserSearchParams STRONGLY_CONSISTENT_ACTIVE_AND_INACTIVE_USERS_ALLOW_EMPTY_QUERY = UserSearchParams.builder().allowEmptyQuery(true).forceStrongConsistency(true).includeActive(true).includeInactive(true).build();
    private static final String EMPTY_QUERY = "";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserSearchService userSearchService;

    public GroupDropdown(JiraAuthenticationContext jiraAuthenticationContext, UserSearchService userSearchService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userSearchService = userSearchService;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.group");
    }

    @Override
    public String getType() {
        return DESC;
    }

    @Override
    public boolean hasPermission(Project project, String group) {
        return group == null;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return parameter == null;
    }

    @Override
    public boolean hasPermission(Project project, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(parameter, user);
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(parameter, user);
    }

    private boolean hasPermission(String groupName, ApplicationUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User passed must not be null");
        }
        if (groupName == null) {
            return true;
        }
        GroupManager groupManager = ComponentAccessor.getGroupManager();
        return groupManager.isUserInGroup(user, groupName);
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String groupName) {
        Set users = groupName == null ? this.findAllUsers() : this.getUserUtil().getAllUsersInGroupNamesUnsorted(Collections.singletonList(groupName));
        return new HashSet<ApplicationUser>(users);
    }

    private Collection<ApplicationUser> findAllUsers() {
        return this.userSearchService.findUsers(EMPTY_QUERY, STRONGLY_CONSISTENT_ACTIVE_AND_INACTIVE_USERS_ALLOW_EMPTY_QUERY);
    }

    private UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

