/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.jira.servermetrics.RequestMetricsDispatcher;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class RequestKeyResolver {
    private static final LinkedHashMap<Pattern, String> KNOWN_REQUESTS = MapBuilder.newBuilder().add((Object)Pattern.compile(".*/IssueNavAction.*\\?.*\\bjql\\b.*\\bserverRenderedViewIssue\\b.*"), (Object)"jira.issue.nav-detail").add((Object)Pattern.compile(".*/IssueNavAction.*\\?.*\\bjql\\b.*"), (Object)"jira.issue.nav-list").add((Object)Pattern.compile(".*/IssueNavAction.*"), (Object)"jira.issue.view").add((Object)Pattern.compile(".*/Dashboard.*"), (Object)"jira.dashboard").add((Object)Pattern.compile(".*/RapidBoard.*"), (Object)"jira.agile.work").toLinkedHashMap();

    public Optional<String> getRequestId(HttpServletRequest httpServletRequest) {
        String request = RequestMetricsDispatcher.getRequestPath(httpServletRequest);
        String parameterString = httpServletRequest.getParameterMap().keySet().stream().sorted().collect(Collectors.joining("&"));
        String pathWithParameters = request + "?" + parameterString;
        return KNOWN_REQUESTS.entrySet().stream().filter(entry -> ((Pattern)entry.getKey()).matcher(pathWithParameters).matches()).map(Map.Entry::getValue).findFirst();
    }
}

