/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics.start;

import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.atlassian.jira.util.tomcat.TomcatConfigReaderHelper;
import com.atlassian.plugin.parsers.SafeModeCommandLineArguments;
import com.atlassian.plugin.parsers.SafeModeCommandLineArgumentsFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class JiraSystemAnalyticTask
implements JiraAnalyticTask {
    private BuildUtilsInfo info;
    private SystemInfoUtils systemInfoUtils;
    private ClusterManager clusterManager;
    private JiraProperties jiraProperties;
    private SafeModeCommandLineArguments safeModeCommandLineArguments;
    private ApplicationProperties applicationProperties;
    private ClusterNodes clusterNodes;
    private TomcatConfigReaderHelper tomcatConfigReaderHelper;
    private JiraLicenseManager licenseManager;

    public JiraSystemAnalyticTask() {
    }

    @VisibleForTesting
    JiraSystemAnalyticTask(BuildUtilsInfo info, SystemInfoUtils systemInfoUtils, ClusterManager clusterManager, JiraProperties jiraProperties, SafeModeCommandLineArgumentsFactory safeModeCommandLineArgumentsFactory, ApplicationProperties applicationProperties, ClusterNodes clusterNodes, TomcatConfigReaderHelper tomcatConfigReaderHelper, JiraLicenseManager licenseManager) {
        this.info = info;
        this.systemInfoUtils = systemInfoUtils;
        this.clusterManager = clusterManager;
        this.jiraProperties = jiraProperties;
        this.safeModeCommandLineArguments = safeModeCommandLineArgumentsFactory.get();
        this.applicationProperties = applicationProperties;
        this.clusterNodes = clusterNodes;
        this.tomcatConfigReaderHelper = tomcatConfigReaderHelper;
        this.licenseManager = licenseManager;
    }

    @Override
    public void init() {
        this.info = (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class);
        this.systemInfoUtils = (SystemInfoUtils)ComponentAccessor.getComponent(SystemInfoUtils.class);
        this.clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        this.jiraProperties = (JiraProperties)ComponentAccessor.getComponent(JiraProperties.class);
        this.safeModeCommandLineArguments = ((SafeModeCommandLineArgumentsFactory)ComponentAccessor.getComponent(SafeModeCommandLineArgumentsFactory.class)).get();
        this.applicationProperties = ComponentAccessor.getApplicationProperties();
        this.clusterNodes = (ClusterNodes)ComponentAccessor.getComponent(ClusterNodes.class);
        this.tomcatConfigReaderHelper = (TomcatConfigReaderHelper)ComponentAccessor.getComponent(TomcatConfigReaderHelper.class);
        this.licenseManager = (JiraLicenseManager)ComponentAccessor.getComponent(JiraLicenseManager.class);
    }

    @Override
    public Map<String, Object> getAnalytics() {
        MapBuilder builder = MapBuilder.newBuilder();
        this.addJiraBuildConfigAnalytics((MapBuilder<String, Object>)builder);
        this.addDataCenterLicenseAnalytics((MapBuilder<String, Object>)builder);
        this.addJavaVirtualMachineAnalytics((MapBuilder<String, Object>)builder);
        this.addLocaleAnalytics((MapBuilder<String, Object>)builder);
        this.addLicenseAnalytics((MapBuilder<String, Object>)builder);
        this.addOperatingSystemAnalytics((MapBuilder<String, Object>)builder);
        this.addPluginsAnalytics((MapBuilder<String, Object>)builder);
        this.addDataBaseAnalytics((MapBuilder<String, Object>)builder);
        return builder.toMap();
    }

    private void addJiraBuildConfigAnalytics(MapBuilder<String, Object> builder) {
        int[] version = this.info.getVersionNumbers();
        builder.add((Object)"release.version", (Object)version[0]);
        builder.add((Object)"major.version", (Object)version[1]);
        builder.add((Object)"minor.version", (Object)version[2]);
        builder.add((Object)"build.number", (Object)this.info.getCurrentBuildNumber());
        builder.add((Object)"build.date", (Object)String.valueOf(this.info.getCurrentBuildDate()));
    }

    private void addDataCenterLicenseAnalytics(MapBuilder<String, Object> builder) {
        builder.add((Object)"license.dc", (Object)this.clusterManager.isClusterLicensed());
        if (this.clusterManager.isClustered()) {
            builder.add((Object)"clustering.restartType", (Object)this.getRestartType(this.clusterManager.findLiveNodes().size()));
            builder.add((Object)"node.id", (Object)JiraSystemAnalyticTask.hash(this.clusterNodes.current().getNodeId()));
        }
    }

    private void addJavaVirtualMachineAnalytics(MapBuilder<String, Object> builder) {
        builder.add((Object)"java.specification.version", (Object)this.jiraProperties.getProperty("java.specification.version"));
        builder.add((Object)"java.version", (Object)this.jiraProperties.getProperty("java.version"));
        builder.add((Object)"java.vendor", (Object)this.jiraProperties.getProperty("java.vendor"));
        builder.add((Object)"java.maxMemory", (Object)this.systemInfoUtils.getTotalMemory());
        builder.add((Object)"java.runtime.name", (Object)this.jiraProperties.getProperty("java.runtime.name"));
        try {
            builder.add((Object)"tomcat.maxThreads", (Object)this.tomcatConfigReaderHelper.getMaxHttpThreads());
        }
        catch (RuntimeException e) {
            builder.add((Object)"tomcat.maxThreads", (Object)"unknown");
        }
    }

    private void addLocaleAnalytics(MapBuilder<String, Object> builder) {
        builder.add((Object)"defaultlocale", (Object)this.applicationProperties.getDefaultLocale().toString());
        builder.add((Object)"server.timezone.offset", (Object)TimeZone.getDefault().getRawOffset());
    }

    private void addLicenseAnalytics(MapBuilder<String, Object> builder) {
        JiraLicense license = this.getJiraLicense();
        builder.add((Object)"users.maxNumber", Objects.nonNull(license) ? Integer.valueOf(license.getMaximumNumberOfUsers()) : "unknown");
        builder.add((Object)"license.evaluation", Objects.nonNull(license) ? Boolean.valueOf(license.isEvaluation()) : "unknown");
    }

    private void addOperatingSystemAnalytics(MapBuilder<String, Object> builder) {
        builder.add((Object)"os.name", (Object)this.jiraProperties.getProperty("os.name", "unknown"));
        builder.add((Object)"os.version", (Object)this.jiraProperties.getProperty("os.version", "unknown"));
        builder.add((Object)"os.arch", (Object)this.jiraProperties.getProperty("os.arch", "unknown"));
        builder.add((Object)"cpu.cores", (Object)Runtime.getRuntime().availableProcessors());
    }

    private void addPluginsAnalytics(MapBuilder<String, Object> builder) {
        builder.add((Object)"plugins.nonsystemaddonsdisabledonstartup", (Object)this.safeModeCommandLineArguments.isSafeMode());
        builder.add((Object)"plugins.specificaddonsweredisabledonstartup", (Object)this.safeModeCommandLineArguments.getDisabledPlugins().isPresent());
        List keys = this.safeModeCommandLineArguments.getDisabledPlugins().orElse(Collections.emptyList()).stream().map(JiraSystemAnalyticTask::hash).collect(Collectors.toList());
        builder.add((Object)"plugins.addonsdisabledonstartup", (Object)String.join((CharSequence)":", keys));
    }

    private void addDataBaseAnalytics(MapBuilder<String, Object> builder) {
        String databaseType = this.systemInfoUtils.getDatabaseType();
        builder.add((Object)"database.name", (Object)databaseType);
        try {
            SystemInfoUtils.DatabaseMetaData databaseMetaData = this.systemInfoUtils.getDatabaseMetaData();
            builder.add((Object)"database.version", (Object)databaseMetaData.getDatabaseProductVersion());
            builder.add((Object)"database.driver.version", (Object)databaseMetaData.getDriverVersion());
            this.systemInfoUtils.getClusteredDatabaseMetaData(databaseType).ifPresent(x -> {
                builder.add((Object)"database.clusteredDatabase.version", (Object)x.getClusteredDBVersion());
                builder.add((Object)"database.clusteredDatabase.name", (Object)x.getClusteredDBName());
                builder.add((Object)"database.clusteredDatabase.memberCount", (Object)x.getMemberCount());
            });
        }
        catch (Exception e) {
            builder.add((Object)"database.version", (Object)"unknown");
            builder.add((Object)"database.driver.version", (Object)"unknown");
        }
    }

    private JiraLicense getJiraLicense() {
        return StreamSupport.stream(this.licenseManager.getLicenses().spliterator(), false).map(LicenseDetails::getJiraLicense).findFirst().orElse(null);
    }

    private String getRestartType(int liveNodesCount) {
        return liveNodesCount == 1 ? "full" : "node";
    }

    private static String hash(String value) {
        return Long.toString(Hashing.sha256().hashString((CharSequence)value, StandardCharsets.UTF_8).asLong());
    }

    @Override
    public boolean isReportingDataShape() {
        return false;
    }
}

