/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.servlet.ApplicationStateResolver;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStateResolverImpl
implements ApplicationStateResolver {
    private static final Logger log = LoggerFactory.getLogger(ApplicationStateResolverImpl.class);
    private final Supplier<Boolean> indexAvailable;
    private final JiraProperties properties;

    public ApplicationStateResolverImpl() {
        this(JiraSystemProperties.getInstance());
    }

    @VisibleForTesting
    ApplicationStateResolverImpl(JiraProperties properties) {
        this.properties = properties;
        this.indexAvailable = Suppliers.memoizeWithExpiration(this::checkIndexAvailable, (long)properties.getLong("com.atlassian.jira.status.index.check.expiration.seconds", Long.valueOf(60L)), (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    public ApplicationState getApplicationState() {
        ComponentManager.State componentManagerState = ComponentManager.getInstance().getState();
        JiraJohnsonContainer jiraJohnsonContainer = this.getJohnsonContainer();
        return this.getApplicationState(componentManagerState, jiraJohnsonContainer);
    }

    private JiraJohnsonContainer getJohnsonContainer() {
        return ComponentAccessor.getComponentSafely(JohnsonProvider.class).orElseGet(DefaultJohnsonProvider::new).getContainer();
    }

    @VisibleForTesting
    ApplicationState getApplicationState(ComponentManager.State state, JiraJohnsonContainer jiraJohnsonContainer) {
        if (jiraJohnsonContainer.hasEventThatPreventsStartup()) {
            if (this.onlyEventIsIndexingOrMissingIndex(jiraJohnsonContainer)) {
                return ApplicationState.MAINTENANCE;
            }
            return ApplicationState.ERROR;
        }
        if (!this.hasStarted(state)) {
            return ApplicationState.STARTING;
        }
        if (ApplicationStateResolverImpl.isFirstRun()) {
            return ApplicationState.FIRST_RUN;
        }
        if (Boolean.FALSE.equals(this.indexAvailable.get())) {
            return ApplicationState.MAINTENANCE;
        }
        return ApplicationState.RUNNING;
    }

    private boolean onlyEventIsIndexingOrMissingIndex(JiraJohnsonContainer jiraJohnsonContainer) {
        return jiraJohnsonContainer.getEventsThatPreventStartup().stream().map(Event::getKey).allMatch(key -> key.equals((Object)JohnsonEventType.REINDEX.eventType()) || key.equals((Object)JohnsonEventType.NO_INDEX.eventType()));
    }

    private boolean hasStarted(ComponentManager.State state) {
        return state.isComponentsRegistered() && state.isContainerInitialised() && state.isPluginSystemStarted() && state.isStarted();
    }

    private boolean checkIndexAvailable() {
        String enabled = this.properties.getProperty("com.atlassian.jira.status.index.check");
        if (enabled != null && !Boolean.parseBoolean(enabled)) {
            return true;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean result = ComponentAccessor.getComponentSafely(IndexLifecycleManager.class).map(IndexLifecycleManager::isIndexConsistent).orElse(false);
        stopwatch.stop();
        log.info("Checking index consistency. Time taken: {}", (Object)stopwatch);
        if (!result) {
            log.warn("The issue index is inconsistent. This node will report its status as MAINTENANCE. You will find information on how to resolve this problem here: https://jira.atlassian.com/browse/JRASERVER-66970");
        }
        return result;
    }

    private static boolean isFirstRun() {
        return !JiraUtils.isSetUp();
    }
}

