/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Iterator;
import java.util.Objects;

public class DefaultShareTypeValidatorUtils
implements ShareTypeValidatorUtils {
    private final ShareTypeFactory shareTypeFactory;
    private final PermissionManager permissionManager;

    public DefaultShareTypeValidatorUtils(ShareTypeFactory shareTypeFactory, PermissionManager permissionManager) {
        this.permissionManager = Objects.requireNonNull(permissionManager);
        this.shareTypeFactory = Objects.requireNonNull(shareTypeFactory);
    }

    @Deprecated
    public boolean isValidSharePermission(JiraServiceContext context, SharedEntity entity) {
        return this.hasValidSharePermissions(context, entity);
    }

    public boolean hasValidSharePermissions(JiraServiceContext context, SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        SharedEntity.SharePermissions permissions = entity.getPermissions();
        Assertions.notNull((String)"permissions", (Object)permissions);
        if (!permissions.isPrivate()) {
            boolean hasPermission = this.permissionManager.hasPermission(22, context.getLoggedInApplicationUser());
            if (!hasPermission) {
                String userName = context.getLoggedInApplicationUser() != null ? context.getLoggedInApplicationUser().getDisplayName() : context.getI18nBean().getText("common.words.Anonymous");
                this.addErrorToContext(context, "shares", "common.sharing.exception.no.share.permission", new Object[0]);
                this.addErrorToContext(context, "shares_delegated", "common.sharing.exception.delegated.user.no.share.permission", userName);
                return false;
            }
            boolean isMoreThanOneViewPerm = this.isContainingMoreThanOne(permissions, ShareRights.VIEW);
            boolean isMoreThanOneViewEditPerm = this.isContainingMoreThanOne(permissions, ShareRights.VIEW_EDIT);
            Iterator iterator = permissions.iterator();
            while (iterator.hasNext()) {
                SharePermission sharePermission;
                this.isValidSharePermission(context, sharePermission, (sharePermission = (SharePermission)iterator.next()).getRights().hasEditRightsGranted() ? isMoreThanOneViewEditPerm : isMoreThanOneViewPerm);
            }
        }
        return !context.getErrorCollection().hasAnyErrors();
    }

    private boolean isContainingMoreThanOne(SharedEntity.SharePermissions permissions, ShareRights rights) {
        return permissions.getPermissionSet().stream().map(SharePermission::getRights).filter(p -> p.equals(rights)).count() > 1L;
    }

    private boolean isValidSharePermission(JiraServiceContext context, SharePermission sharePermission, boolean isMoreThanOnePermissionOfTheSameType) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type == null) {
            this.addErrorToContext(context, "shares", "common.sharing.exception.unknown.type", sharePermission.getType());
        } else {
            if (type.isSingleton() && isMoreThanOnePermissionOfTheSameType) {
                this.addErrorToContext(context, "shares", "common.sharing.exception.singleton", sharePermission.getType());
            }
            type.getValidator().checkSharePermission(context, sharePermission);
        }
        return !context.getErrorCollection().hasAnyErrors();
    }

    public boolean isValidSearchParameter(JiraServiceContext context, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        ShareType.Name shareType = searchParameter.getType();
        ShareType type = this.shareTypeFactory.getShareType(shareType);
        if (type == null) {
            this.addErrorToContext(context, "shares", "common.sharing.exception.unknown.type", shareType);
            return false;
        }
        return type.getValidator().checkSearchParameter(context, searchParameter);
    }

    private void addErrorToContext(JiraServiceContext context, String field, String message, Object ... params) {
        String text = context.getI18nBean().getText(message, (Object)params);
        context.getErrorCollection().addError(field, text);
    }
}

