/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Immutable
public class TemplatesValidationConfig {
    private final Map<Long, TemplateInfo> templateConfigs;

    public TemplatesValidationConfig(Map<Long, TemplateInfo> templateConfigs) {
        this.templateConfigs = Collections.unmodifiableMap(templateConfigs);
    }

    public Map<Long, TemplateInfo> getTemplateConfigs() {
        return this.templateConfigs;
    }

    @Immutable
    public static class TemplateInfo {
        private final long id;
        private final String name;
        private final String template;
        private final String folder;
        private final boolean html;
        private final boolean text;
        private final boolean usedWhenBatchingEnabled;
        private final boolean useForValidation;
        private final boolean useForTestEmail;

        public TemplateInfo(long id, String name, String template, String folder, boolean html, boolean text, boolean usedWhenBatchingEnabled, boolean useForValidation, boolean useForTestEmail) {
            this.id = id;
            this.name = name;
            this.template = template;
            this.folder = folder;
            this.html = html;
            this.text = text;
            this.usedWhenBatchingEnabled = usedWhenBatchingEnabled;
            this.useForValidation = useForValidation;
            this.useForTestEmail = useForTestEmail;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getFolder() {
            return this.folder;
        }

        public boolean isHtml() {
            return this.html;
        }

        public boolean isText() {
            return this.text;
        }

        public boolean isUsedWhenBatchingEnabled() {
            return this.usedWhenBatchingEnabled;
        }

        public boolean isUseForValidation() {
            return this.useForValidation;
        }

        public boolean isUseForTestEmail() {
            return this.useForTestEmail;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateInfo that = (TemplateInfo)o;
            return this.id == that.id && this.html == that.html && this.text == that.text && this.usedWhenBatchingEnabled == that.usedWhenBatchingEnabled && this.useForValidation == that.useForValidation && this.useForTestEmail == that.useForTestEmail && Objects.equals(this.name, that.name) && Objects.equals(this.template, that.template) && Objects.equals(this.folder, that.folder);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.template, this.folder, this.html, this.text, this.usedWhenBatchingEnabled, this.useForValidation, this.useForTestEmail);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("id", this.id).append("name", (Object)this.name).append("template", (Object)this.template).append("folder", (Object)this.folder).append("html", this.html).append("text", this.text).append("usedWhenBatchingEnabled", this.usedWhenBatchingEnabled).append("useForValidation", this.useForValidation).append("useForTestEmail", this.useForTestEmail).toString();
        }
    }
}

