/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.template.CustomTemplatesFeatureAvailabilityCheck;
import com.atlassian.jira.util.BuildUtilsInfoImpl;

public class DefaultCustomTemplatesFeatureAvailabilityCheck
implements CustomTemplatesFeatureAvailabilityCheck {
    @VisibleForTesting
    protected static final String READ_EMAIL_TEMPLATES_FROM_JIRAHOME = "com.atlassian.jira.email.templates.readFromJiraHome";
    private final FeatureManager featureManager;
    private final ClusterManager clusterManager;
    private final JiraProperties jiraProperties;

    public DefaultCustomTemplatesFeatureAvailabilityCheck(FeatureManager featureManager, ClusterManager clusterManager, JiraProperties jiraProperties) {
        this.featureManager = featureManager;
        this.clusterManager = clusterManager;
        this.jiraProperties = jiraProperties;
    }

    public boolean isLicensedForCustomEmailTemplates() {
        return this.isFeatureEnabled() && (this.isDevMode() || this.isLicenseDC());
    }

    public boolean isDatabaseBuildNumberHighEnough() {
        BuildUtilsInfoImpl info = new BuildUtilsInfoImpl();
        return info.getDatabaseBuildNumber() >= 814000;
    }

    private boolean isFeatureEnabled() {
        return this.featureManager.isEnabled(READ_EMAIL_TEMPLATES_FROM_JIRAHOME);
    }

    private boolean isLicenseDC() {
        return this.clusterManager.isClusterLicensed();
    }

    private boolean isDevMode() {
        return this.jiraProperties.isDevMode();
    }
}

