/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template.velocity;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.template.velocity.VelocityEngineFactory;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailVelocityEngineFactory
implements VelocityEngineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EmailVelocityEngineFactory.class);
    private static final String PROPERTIES_FILE_NAME = "velocity-email.properties";
    public static final String FILE_RESOURCE_LOADER_PATH_PROPERTY = "file.resource.loader.path";
    private final String jiraHomeDataDirectoryPath;

    public EmailVelocityEngineFactory(JiraHome jiraHome) {
        this.jiraHomeDataDirectoryPath = jiraHome.getDataDirectory().getAbsolutePath().replace("\\", "\\\\\\\\");
    }

    @Override
    public VelocityEngine getEngine() {
        return this.createEngineWithConfiguration(ClassLoaderUtils.getResourceAsStream((String)PROPERTIES_FILE_NAME, this.getClass()));
    }

    public VelocityEngine createEngineWithConfiguration(@Nonnull InputStream configFile) {
        VelocityEngine velocityEngine = EmailVelocityEngineFactory.instantiateEngine();
        try {
            Properties velocityProperties = new Properties();
            velocityProperties.load(configFile);
            velocityProperties.put(FILE_RESOURCE_LOADER_PATH_PROPERTY, this.jiraHomeDataDirectoryPath);
            velocityEngine.init(velocityProperties);
        }
        catch (Exception e) {
            LOG.error("Error while initialising Velocity Email Templates Engine", (Throwable)e);
        }
        return velocityEngine;
    }

    private static VelocityEngine instantiateEngine() {
        return new VelocityEngine();
    }
}

