/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.CachingTaggingAvatarStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.model.querydsl.QAvatar;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;

public class UpgradeTask_Build800009
implements UpgradeTask {
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build800009(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    public int getBuildNumber() {
        return 800009;
    }

    public String getShortDescription() {
        return "Add new avatars";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        this.queryDslAccessor.execute(connection -> {
            this.addUserAvatars(connection, (Collection<String>)ImmutableList.builder().add((Object)"female_5.svg").add((Object)"female_6.svg").add((Object)"female_7.svg").add((Object)"female_8.svg").add((Object)"female_9.svg").add((Object)"male_7.svg").add((Object)"male_9.svg").add((Object)"pirate_female.svg").add((Object)"princess.svg").build());
            this.addProjectAvatars(connection, (Collection<String>)ImmutableList.of((Object)"spectrum.svg"));
        });
        ComponentAccessor.getComponentSafely(CachingTaggingAvatarStore.class).ifPresent(avatarStore -> avatarStore.onClearCache(ClearCacheEvent.INSTANCE));
    }

    private void addUserAvatars(DbConnection connection, Collection<String> names) {
        this.addAvatars(connection, "user", names);
    }

    private void addProjectAvatars(DbConnection connection, Collection<String> names) {
        this.addAvatars(connection, "project", names);
    }

    private void addAvatars(DbConnection connection, String type, Collection<String> names) {
        List alreadyPresent = ((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QAvatar.AVATAR.fileName).from((Expression)QAvatar.AVATAR)).where((Predicate)QAvatar.AVATAR.avatarType.eq((Object)type))).where((Predicate)QAvatar.AVATAR.systemAvatar.eq((Object)1))).fetch();
        for (String name : names) {
            if (alreadyPresent.contains(name)) continue;
            connection.insert(QAvatar.AVATAR).set((Path)QAvatar.AVATAR.fileName, name).set((Path)QAvatar.AVATAR.contentType, "image/svg+xml").set((Path)QAvatar.AVATAR.avatarType, type).set((Path)QAvatar.AVATAR.systemAvatar, (Object)1).executeWithId();
        }
    }
}

