/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyNumber;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.Monitoring;
import com.google.common.base.Stopwatch;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build940008
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build940008.class);
    private final Duration watchdogMessageInterval;
    private final QueryDslAccessor queryDslAccessor;
    private final ProjectManager projectManager;

    public UpgradeTask_Build940008(QueryDslAccessor queryDslAccessor, ProjectManager projectManager) {
        this(queryDslAccessor, projectManager, Duration.ofSeconds(30L));
    }

    UpgradeTask_Build940008(QueryDslAccessor queryDslAccessor, ProjectManager projectManager, Duration watchdogMessageInterval) {
        this.queryDslAccessor = queryDslAccessor;
        this.projectManager = projectManager;
        this.watchdogMessageInterval = watchdogMessageInterval;
    }

    @Override
    public int getBuildNumber() {
        return 940008;
    }

    @Override
    public String getShortDescription() {
        return "Marks issues archived at project level in jiraissues table to avoid performance problems when counting all archived issues";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) {
        log.info("Marking issues from archived projects in jiraissue table.");
        Stopwatch stopwatch = Stopwatch.createStarted();
        Thread watchdogThread = Monitoring.startWatchdogThreadForCurrentThread("upgrade-940008-watchdog", this.watchdogMessageInterval, log, "[UPGRADE WATCH] Still marking issues as archived.");
        try {
            List archivedProjectsIds = this.queryDslAccessor.executeQuery(connection -> UpgradeTask_Build940008.buildArchivedProjectIdsQuery(connection).fetch());
            if (archivedProjectsIds.isEmpty()) {
                log.info("There are no archived projects. Upgrade task will not perform any operation.");
                return;
            }
            List archivedProjectNames = archivedProjectsIds.stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).filter(Objects::nonNull).map(Project::getName).collect(Collectors.toList());
            log.info("Issues in the following projects will be marked as archived in jiraissue table: {}. The number of archived projects: {}", archivedProjectNames, (Object)archivedProjectNames.size());
            long numberOfUpdatedIssues = this.queryDslAccessor.executeQuery(connection -> connection.update((RelationalPath<?>)QIssue.ISSUE).set((Path)QIssue.ISSUE.archived, (Object)DatabaseUtil.booleanToChar1(true)).where((Predicate)QIssue.ISSUE.project.in(UpgradeTask_Build940008.buildArchivedProjectIdsQuery(connection)).and((Predicate)QIssue.ISSUE.archived.eq((Object)DatabaseUtil.booleanToChar1(false)).or((Predicate)QIssue.ISSUE.archived.isNull()))).execute());
            long elapsedSeconds = stopwatch.elapsed(TimeUnit.SECONDS);
            log.info("{} issues from archived projects have been marked as archived in jiraissue table. The update took {} seconds", (Object)numberOfUpdatedIssues, (Object)elapsedSeconds);
        }
        finally {
            watchdogThread.interrupt();
        }
    }

    private static SQLQuery<Long> buildArchivedProjectIdsQuery(DbConnection connection) {
        return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).leftJoin((EntityPath)QOSPropertyNumber.O_S_PROPERTY_NUMBER)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyNumber.O_S_PROPERTY_NUMBER.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)"jira.archiving.projects").and((Predicate)QOSPropertyNumber.O_S_PROPERTY_NUMBER.value.eq((Object)1L)));
    }
}

