/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizationHandler;
import com.atlassian.jira.user.anonymize.AnonymizationHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.ServiceResultWithWarnings;
import com.atlassian.jira.user.anonymize.TaskContextAware;
import com.atlassian.jira.user.anonymize.UserPropertyChangeManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserPropertyChangeService<H extends AnonymizationHandler<P>, P extends TaskContextAware> {
    private static Logger log = LoggerFactory.getLogger(UserPropertyChangeService.class);

    @Nonnull
    protected abstract UserPropertyChangeManager<H, P> getManager();

    @Nonnull
    protected abstract String getHandlerDescriptionKey();

    public int getNumberOfTasks(@Nonnull P userPropertyChangeParameter) {
        return this.getManager().getNumberOfTasks(userPropertyChangeParameter);
    }

    @Nonnull
    public abstract UserPropertyChangeValidationResult<P> validateUserPropertyChange(@Nonnull UserPropertyChangeRequest<P> var1);

    @Nonnull
    public abstract UserPropertyChangeValidationResult<P> validateUserPropertyChangeInOtherEntities(@Nonnull UserPropertyChangeRequest<P> var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public ServiceResult userPropertyChange(@Nonnull UserPropertyChangeValidationResult<P> userPropertyChangeValidationResult) {
        Assertions.notNull((String)"You can not change user property with null validation result", userPropertyChangeValidationResult);
        Assertions.is((String)"You can not change user property with an invalid validation result.", (boolean)userPropertyChangeValidationResult.isValid());
        Assertions.is((String)"Make sure to call validateUserPropertyChange(UserPropertyChangeRequest) before calling userPropertyChange(UserPropertyChangeValidationResult).", (userPropertyChangeValidationResult.getUserPropertyChangeRequest() != null ? 1 : 0) != 0);
        UserPropertyChangeRequest<P> userPropertyChangeRequest = userPropertyChangeValidationResult.getUserPropertyChangeRequest();
        UserPropertyChangeValidationResult<P> validationResult = this.validateUserPropertyChange(userPropertyChangeRequest);
        if (!validationResult.isValid()) {
            return new ServiceResultWithWarnings(validationResult.getErrorCollection(), Collections.emptyMap());
        }
        I18nHelper i18nBean = this.getI18nBean(userPropertyChangeRequest.getLoggedInUser());
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String handlerDescription = i18nBean.getText(this.getHandlerDescriptionKey());
        log.info("Starting task for handler: {}", (Object)handlerDescription);
        Context context = ((TaskContextAware)userPropertyChangeRequest.getUserPropertyChangeParameter()).getContext();
        try (Context.Task task = context.start(null);){
            context.setName(i18nBean.getText("admin.user.property.change.processing.handler", handlerDescription));
            this.getManager().changeProperty((TaskContextAware)userPropertyChangeRequest.getUserPropertyChangeParameter());
            log.info("Ending task (success) for handler: {}", (Object)handlerDescription);
            ServiceOutcomeImpl<Object> serviceOutcomeImpl = ServiceOutcomeImpl.ok(null);
            return serviceOutcomeImpl;
        }
        catch (Exception e) {
            log.error(String.format("Exception during AnonymizationHandler %s processing", handlerDescription), (Throwable)e);
            errorCollection.addErrorMessage(i18nBean.getText("change.handler.processing.exception", e.getMessage()));
            log.info("Ending task (error) for handler: {}, ({})", (Object)handlerDescription, (Object)errorCollection);
            return ServiceOutcomeImpl.from((ErrorCollection)errorCollection);
        }
    }

    @Nonnull
    public ServiceResultWithWarnings userPropertyChangeInOtherEntities(@Nonnull UserPropertyChangeValidationResult<P> userPropertyChangeValidationResult) {
        Assertions.notNull((String)"You can not change user property with null validation result", userPropertyChangeValidationResult);
        Assertions.is((String)"You can not change user property with an invalid validation result.", (boolean)userPropertyChangeValidationResult.isValid());
        Assertions.is((String)"Make sure to call validateUserPropertyChangeInOtherEntities(UserPropertyChangeRequest) before calling userPropertyChangeInOtherEntities(UserPropertyChangeValidationResult).", (userPropertyChangeValidationResult.getUserPropertyChangeRequest() != null ? 1 : 0) != 0);
        UserPropertyChangeRequest<P> userPropertyChangeRequest = userPropertyChangeValidationResult.getUserPropertyChangeRequest();
        UserPropertyChangeValidationResult<P> validationResult = this.validateUserPropertyChangeInOtherEntities(userPropertyChangeRequest);
        if (!validationResult.isValid()) {
            return new ServiceResultWithWarnings(validationResult.getErrorCollection(), Collections.emptyMap());
        }
        I18nHelper i18nBean = this.getI18nBean(userPropertyChangeRequest.getLoggedInUser());
        Map<AnonymizationHandlerModuleDescriptor, ServiceResult> handlersResult = this.getManager().executeHandlers((TaskContextAware)userPropertyChangeRequest.getUserPropertyChangeParameter(), i18nBean);
        Map<String, ErrorCollection> warningMap = handlersResult.entrySet().stream().filter(entry -> !((ServiceResult)entry.getValue()).isValid()).collect(Collectors.toMap(entry -> ((AnonymizationHandlerModuleDescriptor)((Object)((Object)entry.getKey()))).getCompleteKey(), entry -> ((ServiceResult)entry.getValue()).getErrorCollection()));
        return new ServiceResultWithWarnings((ErrorCollection)new SimpleErrorCollection(), warningMap);
    }

    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(@Nonnull UserPropertyChangeRequest<P> userPropertyChangeRequest) {
        UserPropertyChangeValidationResult<P> validationResult = this.validateUserPropertyChangeInOtherEntities(userPropertyChangeRequest);
        if (!validationResult.isValid()) {
            return new ServiceOutcomeWithWarnings<Object>(null, validationResult.getErrorCollection(), new HashMap<String, ErrorCollection>());
        }
        return this.getAffectedEntitiesFromHandlers(userPropertyChangeRequest);
    }

    @Nonnull
    public BusinessLogicValidationResult validateBusinessLogic(@Nonnull AnonymizationParameters anonymizationParameters) {
        return this.getManager().validateBusinessLogic(anonymizationParameters);
    }

    @Nonnull
    protected ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntitiesFromHandlers(@Nonnull UserPropertyChangeRequest<P> userPropertyChangeRequest) {
        Map<AnonymizationHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> managerResponse = this.getManager().getAffectedEntities((TaskContextAware)userPropertyChangeRequest.getUserPropertyChangeParameter());
        Collection affectedEntities = managerResponse.values().stream().map(ServiceOutcome::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        Map<String, ErrorCollection> warnings = managerResponse.entrySet().stream().filter(entry -> !((ServiceOutcome)entry.getValue()).isValid()).collect(Collectors.toMap(entry -> ((AnonymizationHandlerModuleDescriptor)((Object)((Object)entry.getKey()))).getCompleteKey(), entry -> ((ServiceOutcome)entry.getValue()).getErrorCollection()));
        return new ServiceOutcomeWithWarnings<Collection<AffectedEntity>>(affectedEntities, warnings);
    }

    protected boolean isAdministrator(@Nullable ApplicationUser user) {
        return ComponentAccessor.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    protected boolean isSysAdmin(@Nullable ApplicationUser user) {
        return ComponentAccessor.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    protected I18nHelper getI18nBean(ApplicationUser user) {
        return ComponentAccessor.getI18nHelperFactory().getInstance(user);
    }

    public static class UserPropertyChangeValidationResult<P>
    extends ServiceResultImpl {
        private final UserPropertyChangeRequest<P> userPropertyChangeRequest;

        public UserPropertyChangeValidationResult(@Nonnull UserPropertyChangeRequest<P> userPropertyChangeRequest, @Nonnull ErrorCollection errorCollection) {
            super(errorCollection);
            this.userPropertyChangeRequest = Objects.requireNonNull(userPropertyChangeRequest);
        }

        public UserPropertyChangeValidationResult(@Nonnull UserPropertyChangeRequest<P> userPropertyChangeRequest) {
            this(userPropertyChangeRequest, (ErrorCollection)new SimpleErrorCollection());
        }

        public UserPropertyChangeRequest<P> getUserPropertyChangeRequest() {
            return this.userPropertyChangeRequest;
        }
    }

    public static class UserPropertyChangeRequest<P> {
        private final ApplicationUser loggedInUser;
        private final P userPropertyChangeParameter;

        public UserPropertyChangeRequest(@Nullable ApplicationUser loggedInUser, @Nonnull P userPropertyChangeParameter) {
            this.loggedInUser = loggedInUser;
            this.userPropertyChangeParameter = Objects.requireNonNull(userPropertyChangeParameter);
        }

        @Nonnull
        public P getUserPropertyChangeParameter() {
            return this.userPropertyChangeParameter;
        }

        @Nullable
        public ApplicationUser getLoggedInUser() {
            return this.loggedInUser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserPropertyChangeRequest that = (UserPropertyChangeRequest)o;
            return Objects.equals(this.loggedInUser, that.loggedInUser) && Objects.equals(this.userPropertyChangeParameter, that.userPropertyChangeParameter);
        }

        public int hashCode() {
            return Objects.hash(this.loggedInUser, this.userPropertyChangeParameter);
        }

        public String toString() {
            return "UserPropertyChangeRequest{loggedInUser=" + this.loggedInUser + ", userPropertyChangeParameter=" + this.userPropertyChangeParameter + '}';
        }
    }
}

