/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.user.anonymize.AdditionalAnonymizationData;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.MultiUserFieldHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.utils.MultiUserPickerSanitizer;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DisplayNameInMultiUserFieldHistory
implements UserAnonymizationHandler {
    private final QueryDslAccessor queryDslAccessor;
    private final DatabaseAccessor databaseAccessor;
    private final UserManager userManager;
    private final UserKeyStore userKeyStore;
    private final List<IssueHistoryInfo> infos;

    public DisplayNameInMultiUserFieldHistory(QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, UserManager userManager, UserKeyStore userKeyStore) {
        this.queryDslAccessor = queryDslAccessor;
        this.databaseAccessor = databaseAccessor;
        this.userManager = userManager;
        this.userKeyStore = userKeyStore;
        this.infos = ImmutableList.of((Object)new MultiUserFieldHistoryInfo(QChangeItem.CHANGE_ITEM.oldvalue, QChangeItem.CHANGE_ITEM.oldstring), (Object)new MultiUserFieldHistoryInfo(QChangeItem.CHANGE_ITEM.newvalue, QChangeItem.CHANGE_ITEM.newstring));
    }

    @VisibleForTesting
    DisplayNameInMultiUserFieldHistory(QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, UserManager userManager, UserKeyStore userKeyStore, List<IssueHistoryInfo> infos) {
        this.queryDslAccessor = queryDslAccessor;
        this.databaseAccessor = databaseAccessor;
        this.userManager = userManager;
        this.userKeyStore = userKeyStore;
        this.infos = infos;
    }

    public Collection<AffectedEntity> getAffectedEntities(UserAnonymizationParameter parameter) {
        throw new UnsupportedOperationException();
    }

    public ServiceResult update(UserAnonymizationParameter parameter) {
        String oldDisplayName = DisplayNameInMultiUserFieldHistory.getOldDisplayName(parameter);
        String newDisplayName = Optional.ofNullable(this.userManager.getUserByKey(parameter.getUserKey())).map(user -> this.userKeyStore.getKeyFromId(user.getId())).orElse(parameter.getUserKey());
        for (IssueHistoryInfo info : this.infos) {
            for (long id : this.getAffectedEntitiesIds(parameter.getUserKey(), info)) {
                this.updateCustomField(id, info, parameter.getUserKey(), newDisplayName, oldDisplayName);
            }
        }
        return new ServiceResultImpl();
    }

    private static String getOldDisplayName(UserAnonymizationParameter parameter) {
        if (parameter instanceof AdditionalAnonymizationData) {
            return ((AdditionalAnonymizationData)parameter).getFullName().orElse(parameter.getUserKey());
        }
        return parameter.getUserKey();
    }

    private List<Long> getAffectedEntitiesIds(String original, IssueHistoryInfo foreignKeyInfo) {
        return this.queryDslAccessor.executeQuery(connection -> this.getBaseQuery(original, foreignKeyInfo, connection).fetch());
    }

    private SQLQuery<Long> getBaseQuery(String original, IssueHistoryInfo foreignKeyInfo, DbConnection connection) {
        return (SQLQuery)((SQLQuery)connection.newSqlQuery().select(foreignKeyInfo.getSelect()).from((Expression)foreignKeyInfo.getTable())).where(foreignKeyInfo.getWhere(original, this.databaseAccessor.getDatabaseVendor()));
    }

    private void updateCustomField(Long id, IssueHistoryInfo info, String original, String target, String fullNameOriginal) {
        this.queryDslAccessor.execute(connection -> {
            Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(new Expression[]{info.getColumn(), info.getColumnHumanReadable()}).from((Expression)info.getTable())).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id))).fetchFirst();
            String dbValue = StringUtils.defaultString((String)((String)tuple.get(info.getColumn())));
            String humanReadableValue = StringUtils.defaultString((String)((String)tuple.get((Expression)info.getColumnHumanReadable())));
            MultiUserPickerSanitizer multiUserPickerSanitizer = new MultiUserPickerSanitizer(dbValue, humanReadableValue, fullNameOriginal, original, target);
            String newHumanReadableValue = multiUserPickerSanitizer.getHumanReadableValueSanitized();
            connection.update((RelationalPath<?>)info.getTable()).set((Path)info.getColumnHumanReadable(), (Object)newHumanReadableValue).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id)).execute();
        });
    }

    public int getNumberOfTasks(UserAnonymizationParameter userPropertyChangeParameter) {
        throw new UnsupportedOperationException();
    }
}

