/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.utils;

import com.atlassian.jira.user.anonymize.handlers.utils.MultiValueChangeItemUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class MultiUserPickerSanitizer {
    private static final String DELIMITER = ", ";
    private static final Pattern DELIMITER_PATTERN = Pattern.compile(", ");
    private final String dbValue;
    private final String humanReadableValue;
    private final String currentFullName;
    private final String originalValue;
    private final String targetValue;

    public MultiUserPickerSanitizer(@Nonnull String dbValue, @Nonnull String humanReadableValue, @Nonnull String currentFullName, @Nonnull String originalValue, @Nonnull String targetValue) {
        this.dbValue = Objects.requireNonNull(dbValue);
        this.humanReadableValue = Objects.requireNonNull(humanReadableValue);
        this.currentFullName = Objects.requireNonNull(currentFullName);
        this.originalValue = Objects.requireNonNull(originalValue);
        this.targetValue = Objects.requireNonNull(targetValue);
    }

    @Nonnull
    public String getDbValueSanitized() {
        if (this.originalValue.contains(",")) {
            if (!this.dbValue.startsWith("[") || !this.dbValue.endsWith("]")) {
                return this.dbValue;
            }
            String strippedValue = this.dbValue.substring(1, this.dbValue.length() - 1);
            return "[" + this.replace(strippedValue, this.originalValue, this.targetValue, false) + "]";
        }
        return MultiValueChangeItemUtil.replace(this.dbValue, this.originalValue, this.targetValue);
    }

    @Nonnull
    public String getHumanReadableValueSanitized() {
        Optional<String> replaceFullName = this.replaceFullName();
        if (replaceFullName.isPresent()) {
            return replaceFullName.get();
        }
        Optional<String> replaceByIndexMatch = this.replaceByIndexMatch();
        return replaceByIndexMatch.orElse(this.humanReadableValue);
    }

    private Optional<String> replaceByIndexMatch() {
        CharSequence[] stringSplit;
        String[] valueSplit = this.splitValue(this.dbValue);
        if (valueSplit.length == (stringSplit = DELIMITER_PATTERN.split(this.humanReadableValue)).length) {
            IntPredicate findElementPredicate = idx -> this.originalValue.equalsIgnoreCase(valueSplit[idx]);
            OptionalInt idxFound = IntStream.range(0, valueSplit.length).filter(findElementPredicate).findFirst();
            if (idxFound.isPresent()) {
                stringSplit[idxFound.getAsInt()] = this.targetValue;
                return Optional.of(String.join((CharSequence)DELIMITER, stringSplit));
            }
        }
        return Optional.empty();
    }

    private Optional<String> replaceFullName() {
        String replaced = this.replace(this.humanReadableValue, this.currentFullName, this.targetValue, true);
        if (!replaced.equals(this.humanReadableValue)) {
            return Optional.of(replaced);
        }
        return Optional.empty();
    }

    private String replace(String string, String searchFor, String replaceWith, boolean caseInsensitive) {
        String quote = Pattern.quote(searchFor);
        int patternFlags = caseInsensitive ? 66 : 0;
        string = Pattern.compile(String.format("^%1$s$", quote), patternFlags).matcher(string).replaceAll(replaceWith);
        string = Pattern.compile(String.format("^%1$s%2$s", quote, DELIMITER), patternFlags).matcher(string).replaceAll(replaceWith + DELIMITER);
        string = Pattern.compile(String.format("%2$s%1$s$", quote, DELIMITER), patternFlags).matcher(string).replaceAll(DELIMITER + replaceWith);
        string = Pattern.compile(String.format("%2$s%1$s%2$s", quote, DELIMITER), patternFlags).matcher(string).replaceAll(DELIMITER + replaceWith + DELIMITER);
        return string;
    }

    private String[] splitValue(String value) {
        if (value.startsWith("[")) {
            value = value.substring(1);
        }
        if (value.endsWith("]")) {
            value = value.substring(0, value.length() - 1);
        }
        return DELIMITER_PATTERN.split(value);
    }
}

