/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.FileFactory;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFileFactory
implements FileFactory {
    private static final Logger log = LoggerFactory.getLogger(FileSystemFileFactory.class);
    private final JiraProperties jiraSystemProperties;

    public FileSystemFileFactory(JiraProperties jiraSystemProperties) {
        this.jiraSystemProperties = jiraSystemProperties;
    }

    @Override
    public File getFile(String absoluteFilename) {
        return new File(absoluteFilename);
    }

    @Override
    public void removeDirectoryIfExists(String directoryName) {
        File file = this.getFile(directoryName);
        if (file.exists()) {
            this.removeDirectory(file);
        }
    }

    @Override
    public void removeDirectory(File directory) {
        String[] list = directory.list();
        if (list == null) {
            list = new String[]{};
        }
        for (String filename : list) {
            File f = this.getFile(directory.getAbsolutePath() + this.jiraSystemProperties.getProperty("file.separator") + filename);
            if (f.isDirectory()) {
                this.removeDirectory(f);
                continue;
            }
            log.debug("Deleting " + f.getAbsolutePath());
            if (f.delete()) continue;
            log.warn("Unable to delete file " + f.getAbsolutePath());
        }
        if (!directory.delete()) {
            log.error("Unable to delete directory " + directory.getAbsolutePath());
        }
    }
}

