/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.compression;

import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.util.compression.ArchiveDecompressor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractArchiveDecompressor
implements ArchiveDecompressor {
    private static final Logger log = LoggerFactory.getLogger(AbstractArchiveDecompressor.class);

    AbstractArchiveDecompressor() {
    }

    abstract ArchiveInputStream createArchiveInputStream(BufferedInputStream var1) throws IOException;

    @Override
    public void decompress(File input, File outputDir) throws IOException {
        log.debug("Start decompressing file: {} to directory: {}", (Object)input.getPath(), (Object)outputDir.getPath());
        if (!input.exists()) {
            throw new FileNotFoundException(input.getPath());
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        } else {
            if (!outputDir.isDirectory()) {
                throw new IOException("'" + outputDir.getPath() + "' exists but is not a directory. Cannot overwrite.");
            }
            if (!outputDir.canWrite()) {
                throw new IOException("'" + outputDir.getPath() + "' exists and is not writable.");
            }
        }
        try (ArchiveInputStream in = this.createArchiveInputStream(new BufferedInputStream(new FileInputStream(input)));){
            ArchiveEntry entry;
            do {
                if ((entry = in.getNextEntry()) == null || entry.isDirectory()) continue;
                String fileName = entry.getName();
                File file = new File(outputDir, fileName);
                if (!PathUtils.isChildPath((File)outputDir, (File)file)) {
                    log.warn("Zip entry from {} refers to a location outside of the intended destination, it refers to '{}', and has been skipped.", (Object)input, (Object)file);
                    continue;
                }
                file.getParentFile().mkdirs();
                try (FileOutputStream out = new FileOutputStream(file);){
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
            } while (entry != null);
        }
        log.debug("Done decompressing file: {} to directory: {}", (Object)input.getPath(), (Object)outputDir.getPath());
    }
}

