/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.devspeed;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;

public class JiraDevSpeedTimer {
    private final String task;
    private final long then = System.currentTimeMillis();

    public static void run(String task, Runnable runnable) {
        JiraDevSpeedTimer jiraDevSpeedTimer = new JiraDevSpeedTimer(task);
        try {
            runnable.run();
        }
        finally {
            jiraDevSpeedTimer.end();
        }
    }

    JiraDevSpeedTimer(String task) {
        this.task = task;
    }

    void end() {
        long now = System.currentTimeMillis();
        if (JiraSystemProperties.isDevMode()) {
            this.appendRecord(now);
        }
    }

    private void appendRecord(long now) {
        long howLongSec = (now - this.then) / 1000L;
        Date nowDate = new Date();
        try {
            JiraProperties jiraProperties = JiraSystemProperties.getInstance();
            String userDotHome = jiraProperties.getProperty("user.home");
            String userDotName = jiraProperties.getProperty("user.name");
            File userHome = new File(userDotHome);
            if (userHome.exists()) {
                File targetDir = new File(userHome, ".jiradev");
                targetDir.mkdirs();
                File targetFile = new File(targetDir, "jiratimers.csv");
                PrintWriter pw = new PrintWriter(new FileWriter(targetFile, true));
                pw.printf("%tF %tT,%s,%s,%d\n", nowDate, nowDate, userDotName, this.task, howLongSec);
                pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

