/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.function;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class Predicates {
    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> extractor) {
        return Predicates.distinctByKey(extractor, ConcurrentHashMap.newKeySet());
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> extractor, int initialCapacity) {
        return Predicates.distinctByKey(extractor, ConcurrentHashMap.newKeySet(initialCapacity));
    }

    public static <T, S extends Set<Object>> Predicate<T> distinctByKey(Function<? super T, Object> extractor, S seenSet) {
        return t -> seenSet.add(extractor.apply(t));
    }
}

