/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.IndexingFailureException;
import com.atlassian.jira.index.ha.DefaultServerIndexRepairService;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.RuntimeInterruptedException;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeIndexLifecycleManager
implements IndexLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(CompositeIndexLifecycleManager.class);
    private final IndexLifecycleManager[] delegates;
    private final IndexingCounterManager indexingCounterManager;

    public CompositeIndexLifecycleManager(IssueIndexManager issueIndexManager, SharedEntityIndexManager sharedEntityIndexManager, IndexingCounterManager indexingCounterManager) {
        this.delegates = new IndexLifecycleManager[]{issueIndexManager, sharedEntityIndexManager};
        this.indexingCounterManager = indexingCounterManager;
    }

    public long optimize() {
        log.info("Optimize Indexes starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            long optimize = delegate.optimize();
            log.info("Optimize took: " + optimize + "ms. Indexer: " + delegate.toString());
            result += optimize;
        }
        log.info("Optimize Indexes complete. Total time: " + result + "ms.");
        return result;
    }

    public long reIndexAll(Context context) {
        return this.reIndexAll(context, IssueIndexingParams.INDEX_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexAll(Context context, IssueIndexingParams issueIndexingParams) {
        log.info("Reindex All starting...");
        Optional repairService = ComponentAccessor.getComponentSafely(DefaultServerIndexRepairService.class);
        repairService.ifPresent(DefaultServerIndexRepairService::pause);
        NodeReindexService nodeReindexService = (NodeReindexService)ComponentAccessor.getComponent(NodeReindexService.class);
        nodeReindexService.pause();
        nodeReindexService.resetIndexCount();
        long result = 0L;
        try {
            int failures = 0;
            for (IndexLifecycleManager delegate : this.delegates) {
                try {
                    long reIndexAll = delegate.reIndexAll(context, issueIndexingParams);
                    if (reIndexAll < 0L) {
                        log.error("Reindex All - fatal error. Indexer: {}", (Object)delegate.toString());
                        ++failures;
                        break;
                    }
                    log.info("Reindex took: " + reIndexAll + "ms. Indexer: " + delegate.toString());
                    result += reIndexAll;
                }
                catch (RuntimeException re) {
                    log.error("Reindexing encountered an error for one of the indexers. Reindex all continues. Error for indexer: {}", (Object)delegate.toString(), (Object)re);
                    ++failures;
                }
            }
            if (failures > 0) {
                throw new IndexingFailureException(failures);
            }
        }
        finally {
            nodeReindexService.start();
            repairService.ifPresent(DefaultServerIndexRepairService::start);
        }
        long newCounterValue = this.indexingCounterManager.incrementValue();
        context.setName("");
        log.info("Reindex All COMPLETED without any errors. Total time: {}ms. Reindex run: {}", (Object)result, (Object)newCounterValue);
        return result;
    }

    public long reIndexAllIssuesInBackground(Context context) {
        return this.reIndexIssuesInBackground(context, IssueIndexingParams.INDEX_ISSUE_ONLY);
    }

    public long reIndexIssuesInBackground(Context context, IssueIndexingParams issueIndexingParams) {
        log.info("Reindex All In Background starting...");
        long result = 0L;
        int failures = 0;
        for (IndexLifecycleManager delegate : this.delegates) {
            try {
                long reIndexAll = delegate.reIndexIssuesInBackground(context, issueIndexingParams);
                log.info("Reindex took: " + reIndexAll + "ms. Indexer: " + delegate.toString());
                result += reIndexAll;
                if (reIndexAll >= 0L) continue;
                log.error("Reindex All - fatal error. Indexer: {}", (Object)delegate.toString());
                ++failures;
                break;
            }
            catch (RuntimeInterruptedException rie) {
                log.warn("Reindex All In Background CANCELLED. Indexer: " + delegate.toString());
                throw rie;
            }
            catch (RuntimeException re) {
                log.error("Reindexing in background encountered an error for one of the indexers. Reindex all continues. Error for indexer: {}", (Object)delegate.toString(), (Object)re);
                ++failures;
            }
        }
        if (failures > 0) {
            throw new IndexingFailureException(failures);
        }
        long newCounterValue = this.indexingCounterManager.incrementValue();
        context.setName("");
        log.info("Reindex All In Background COMPLETED without errors. Total time: {}ms. Reindex run: {}", (Object)result, (Object)newCounterValue);
        return result;
    }

    public void shutdown() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.shutdown();
        }
    }

    public long activate(Context context) {
        return this.activate(context, true);
    }

    public long activate(Context context, boolean reindex) {
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.activate(context, reindex);
        }
        return result;
    }

    public void deactivate() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.deactivate();
        }
    }

    public boolean isIndexAvailable() {
        return this.delegates[0].isIndexAvailable();
    }

    public boolean isIndexConsistent() {
        for (IndexLifecycleManager delegate : this.delegates) {
            if (delegate.isIndexConsistent()) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getAllIndexPaths() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.delegates.length);
        for (IndexLifecycleManager delegate : this.delegates) {
            result.addAll(delegate.getAllIndexPaths());
        }
        return Collections.unmodifiableCollection(result);
    }

    public int size() {
        int result = 0;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.size();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

