/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.SerializableStats;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

abstract class AbstractTopNSerializableStats<V, S>
implements SerializableStats<S> {
    private static final Comparator<Map.Entry<String, AtomicLong>> COMPARE_MAP_ENTRY_BY_VALUE_DESC_THEN_BY_KEY_ASC = Map.Entry.comparingByValue(Comparator.comparingLong(AtomicLong::longValue).reversed()).thenComparing(Map.Entry.comparingByKey());
    private final int maxValuesPrinted;
    private final int maxStringLength;
    private final LoadingCache<String, AtomicLong> values;

    protected AbstractTopNSerializableStats(int maxValuesStored, int maxValuesPrinted, int maxStringLength) {
        Preconditions.checkArgument((maxValuesStored <= 1000 ? 1 : 0) != 0, (String)"To avoid OOME, the maximum number of values that can be stored is hard-limited to 1000, but %s were requested", (int)maxValuesStored);
        Preconditions.checkArgument((maxValuesPrinted <= 1000 ? 1 : 0) != 0, (String)"To avoid extremely long log messages, the maximum number of values that can be printed is hard-limited to 1000, but %s were requested", (int)maxValuesPrinted);
        Preconditions.checkArgument((maxStringLength <= 200 ? 1 : 0) != 0, (String)"To avoid extremely long log messages, the length of the strings is hard-limited to 200, but %s was requested", (int)maxStringLength);
        this.maxValuesPrinted = maxValuesPrinted;
        this.maxStringLength = maxStringLength;
        this.values = CacheBuilder.newBuilder().maximumSize((long)maxValuesStored).build((CacheLoader)new CacheLoader<String, AtomicLong>(){

            public AtomicLong load(String key) {
                return new AtomicLong(0L);
            }
        });
    }

    public void storeAll(Collection<V> values) {
        for (V inputObject : values) {
            this.store(inputObject);
        }
    }

    public void store(V value) {
        String inputAsString = this.mapToLimitedLengthString(value);
        ((AtomicLong)this.values.getUnchecked((Object)inputAsString)).incrementAndGet();
    }

    private String mapToLimitedLengthString(V input) {
        String inputAsString = String.valueOf(input);
        if (inputAsString.length() > this.maxStringLength) {
            return inputAsString.substring(0, this.maxStringLength) + "... @" + inputAsString.hashCode() + "";
        }
        return inputAsString;
    }

    protected Stream<Map.Entry<String, AtomicLong>> getValueStream() {
        return this.values.asMap().entrySet().stream().sorted(COMPARE_MAP_ENTRY_BY_VALUE_DESC_THEN_BY_KEY_ASC).limit(this.maxValuesPrinted);
    }
}

