/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class LongStats {
    public static final long MAX_DISTRIBUTION = Long.MAX_VALUE;
    public final long count;
    public final long min;
    public final long max;
    public final long sum;
    public final long avg;
    public final ImmutableSortedMap<Long, Long> distributionCounter;

    protected LongStats(long count, long min, long max, long sum, Map<Long, Long> distributionCounter) {
        this.count = count;
        this.min = min == Long.MAX_VALUE ? 0L : min;
        this.max = max == Long.MIN_VALUE ? 0L : max;
        this.sum = sum;
        this.avg = count > 0L ? sum / count : 0L;
        this.distributionCounter = ImmutableSortedMap.copyOf(distributionCounter);
    }

    static LongStats create(MutableLongStats mutableLongStats) {
        Map<Long, Long> distributionStats = ImmutableMap.copyOf(mutableLongStats.distributionStats).entrySet().stream().filter(entry -> (Long)entry.getKey() < Long.MAX_VALUE || ((AtomicLong)entry.getValue()).get() > 0L).collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
        return new LongStats(mutableLongStats.count.get(), mutableLongStats.min.get(), mutableLongStats.max.get(), mutableLongStats.sum.get(), distributionStats);
    }

    public static LongStats averageMergeWithOther(LongStats a, LongStats b) {
        return new LongStats(a.count, a.min + b.avg, a.max + b.avg, a.sum + a.count * b.avg, Collections.emptyMap());
    }

    public long count() {
        return this.count;
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public long sum() {
        return this.sum;
    }

    public long avg() {
        return this.avg;
    }

    public ImmutableSortedMap<Long, Long> distributionCounter() {
        return this.distributionCounter;
    }

    public String toString() {
        return "{count=" + this.count + ", min=" + this.min + ", max=" + this.max + ", sum=" + this.sum + ", avg=" + this.avg + ", distributionCounter=" + this.distributionCounter + '}';
    }
}

