/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jdk.utilities.runtimeinformation.MemoryInformation;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.cache.HashRegistryCache;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.configurableobjects.ConfigurableObjectUtil;
import com.atlassian.jira.database.measure.DatabaseLatencyMeter;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationService;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationUtil;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.analytics.JiraStartStopAnalyticHelper;
import com.atlassian.jira.startup.PluginComparator;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryItem;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryManager;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryReader;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.JiraLogLocator;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.atlassian.jira.util.system.SystemInfoUtilsImpl;
import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;

public class ExtendedSystemInfoUtilsImpl
implements ExtendedSystemInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(ExtendedSystemInfoUtilsImpl.class);
    private static final List<String> DEFAULT_PROPS = ImmutableList.copyOf(Arrays.asList("user.dir", "java.version", "java.vendor", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.version", "java.runtime.name", "java.vm.name", "user.name", "user.timezone", "file.encoding", "os.name", "os.version", "os.arch"));
    private static final List<Pattern> SECURITY_BLACKLISTED_PROPS = ExtendedSystemInfoUtilsImpl.compile("License.*", "jira\\.sid\\.key", "org\\.apache\\.shindig\\.common\\.crypto\\.BlobCrypter\\:key", "applinks\\..*");
    private static final Map<String, String> DB_STATS_WHITELIST = ImmutableMap.builder().put((Object)"issues", (Object)"admin.systeminfo.issues").put((Object)"projects", (Object)"admin.systeminfo.projects").put((Object)"archivedissues", (Object)"admin.systeminfo.archivedissues").put((Object)"archivedprojects", (Object)"admin.systeminfo.archivedprojects").put((Object)"issuesinarchivedprojects", (Object)"admin.systeminfo.issuesinarchivedprojects").put((Object)"issuesarchivedindividually", (Object)"admin.systeminfo.issuesarchivedindividually").put((Object)"customfields", (Object)"admin.systeminfo.custom.fields").put((Object)"workflows", (Object)"admin.systeminfo.workflows").put((Object)"comments", (Object)"admin.systeminfo.comments").put((Object)"versions", (Object)"admin.systeminfo.versions").put((Object)"components", (Object)"admin.systeminfo.components").put((Object)"status", (Object)"admin.systeminfo.statuses").put((Object)"resolutions", (Object)"admin.systeminfo.resolutions").put((Object)"issuetypes", (Object)"admin.systeminfo.issuetypes").put((Object)"priorities", (Object)"admin.systeminfo.priorities").put((Object)"screens", (Object)"admin.systeminfo.screens").put((Object)"screensschemes", (Object)"admin.systeminfo.screensschemes").put((Object)"permissionsschemes", (Object)"admin.systeminfo.permissionschemes").put((Object)"issuesecuritylevels", (Object)"admin.systeminfo.issuesecuritylevels").build();
    private static final Comparator<GenericValue> COMPARE_BY_NAME = (gv1, gv2) -> gv1.getString("name").compareTo(gv2.getString("name"));
    private final DateFormat dateFormatter = new SimpleDateFormat("EEEEE, dd MMM yyyy");
    private final DateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss Z");
    private final SystemInfoUtils systemInfoUtils;
    private final ServiceManager serviceManager;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final TrustedApplicationService trustedAppService;
    private final OfBizDelegator ofBizDelegator;
    private final I18nHelper i18nHelper;
    private final HashRegistryCache registry;
    private final LocaleManager localeManager;
    private final Optional<JiraLicenseService> jiraLicenseServiceRef;
    private final BuildUtilsInfo buildUtilsInfo;
    private final Optional<UpgradeVersionHistoryManager> upgradeVersionHistoryManagerRef;
    private final JiraProperties jiraSystemProperties;
    private final ClusterManager clusterManager;
    private final JiraStartStopAnalyticHelper jiraStartStopAnalyticHelper;
    private final DatabaseLatencyMeter databaseLatencyMeter;
    private final FeatureManager featureManager;

    protected ExtendedSystemInfoUtilsImpl(SystemInfoUtils systemInfoUtils, ServiceManager serviceManager, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, TrustedApplicationService trustedAppService, OfBizDelegator ofBizDelegator, I18nHelper i18nHelper, HashRegistryCache registry, LocaleManager localeManager, Optional<JiraLicenseService> jiraLicenseServiceRef, BuildUtilsInfo buildUtilsInfo, Optional<UpgradeVersionHistoryManager> upgradeVersionHistoryManagerRef, JiraProperties jiraSystemProperties, ClusterManager clusterManager, JiraStartStopAnalyticHelper jiraStartStopAnalyticHelper, DatabaseLatencyMeter databaseLatencyMeter, FeatureManager featureManager) {
        this.systemInfoUtils = systemInfoUtils;
        this.serviceManager = serviceManager;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.trustedAppService = trustedAppService;
        this.ofBizDelegator = ofBizDelegator;
        this.i18nHelper = i18nHelper;
        this.registry = registry;
        this.localeManager = localeManager;
        this.jiraSystemProperties = jiraSystemProperties;
        this.clusterManager = clusterManager;
        this.jiraStartStopAnalyticHelper = jiraStartStopAnalyticHelper;
        this.jiraLicenseServiceRef = jiraLicenseServiceRef;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.upgradeVersionHistoryManagerRef = upgradeVersionHistoryManagerRef;
        this.databaseLatencyMeter = databaseLatencyMeter;
        this.featureManager = featureManager;
    }

    public ExtendedSystemInfoUtilsImpl(I18nHelper i18nHelper) {
        this(new SystemInfoUtilsImpl(), (ServiceManager)ComponentAccessor.getComponent(ServiceManager.class), (PluginAccessor)ComponentAccessor.getComponent(PluginAccessor.class), ComponentAccessor.getApplicationProperties(), (TrustedApplicationService)ComponentAccessor.getComponent(TrustedApplicationService.class), ComponentAccessor.getOfBizDelegator(), i18nHelper, (HashRegistryCache)ComponentAccessor.getComponent(HashRegistryCache.class), (LocaleManager)ComponentAccessor.getComponent(LocaleManager.class), ComponentAccessor.getComponentSafely(JiraLicenseService.class), (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class), ComponentAccessor.getComponentSafely(UpgradeVersionHistoryManager.class), (JiraProperties)ComponentAccessor.getComponent(JiraProperties.class), (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class), (JiraStartStopAnalyticHelper)ComponentAccessor.getComponent(JiraStartStopAnalyticHelper.class), (DatabaseLatencyMeter)ComponentAccessor.getComponent(DatabaseLatencyMeter.class), (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class));
    }

    @Override
    public SystemInfoUtils getSystemInfoUtils() {
        return this.systemInfoUtils;
    }

    @Override
    public Map<String, String> getProps() {
        return this.getProps(false);
    }

    @Override
    public Map<String, String> getProps(boolean showSensitiveInfo) {
        MapBuilder props = MapBuilder.newBuilder();
        Map sysProps = this.jiraSystemProperties.getSanitisedProperties();
        props.add((Object)this.getText("admin.systeminfo.system.date"), (Object)this.dateFormatter.format(new Date()));
        props.add((Object)this.getText("admin.systeminfo.system.time"), (Object)this.timeFormatter.format(new Date()));
        props.add((Object)this.getText("admin.systeminfo.system.cwd"), sysProps.get("user.dir"));
        props.add((Object)this.getText("admin.systeminfo.java.version"), sysProps.get("java.version"));
        props.add((Object)this.getText("admin.systeminfo.java.vendor"), sysProps.get("java.vendor"));
        props.add((Object)this.getText("admin.systeminfo.jvm.version"), sysProps.get("java.vm.specification.version"));
        props.add((Object)this.getText("admin.systeminfo.jvm.vendor"), sysProps.get("java.vm.specification.vendor"));
        props.add((Object)this.getText("admin.systeminfo.jvm.implementation.version"), sysProps.get("java.vm.version"));
        props.add((Object)this.getText("admin.systeminfo.java.runtime"), sysProps.get("java.runtime.name"));
        props.add((Object)this.getText("admin.systeminfo.java.vm"), sysProps.get("java.vm.name"));
        props.add((Object)this.getText("admin.systeminfo.user.name"), sysProps.get("user.name"));
        props.add((Object)this.getText("admin.systeminfo.user.timezone"), sysProps.get("user.timezone"));
        props.add((Object)this.getText("admin.systeminfo.user.locale"), (Object)(Locale.getDefault() == null ? "null" : Locale.getDefault().getDisplayName()));
        props.add((Object)this.getText("admin.systeminfo.system.encoding"), sysProps.get("file.encoding"));
        props.add((Object)this.getText("admin.systeminfo.operating.system"), (Object)((String)sysProps.get("os.name") + " " + (String)sysProps.get("os.version")));
        props.add((Object)this.getText("admin.systeminfo.os.architecture"), sysProps.get("os.arch"));
        String serverInfo = "";
        try {
            serverInfo = ActionContext.getServletContext().getServerInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        props.add((Object)this.getText("admin.systeminfo.application.server.container"), (Object)serverInfo);
        props.add((Object)this.getText("admin.systeminfo.database.type"), (Object)this.systemInfoUtils.getDatabaseType());
        props.add((Object)this.getText("admin.systeminfo.database.jndi.address"), (Object)this.systemInfoUtils.getDbDescriptorValue());
        try {
            SystemInfoUtils.DatabaseMetaData databaseMetaData = this.systemInfoUtils.getDatabaseMetaData();
            if (showSensitiveInfo) {
                props.add((Object)this.getText("admin.systeminfo.database.url"), (Object)databaseMetaData.getMaskedURL());
            } else {
                props.add((Object)this.getText("admin.systeminfo.database.url"), (Object)this.getText("admin.systeminfo.hidden.field"));
            }
            props.add((Object)this.getText("admin.systeminfo.database.version"), (Object)databaseMetaData.getDatabaseProductVersion());
            props.add((Object)this.getText("admin.systeminfo.database.driver"), (Object)(databaseMetaData.getDriverName() + " " + databaseMetaData.getDriverVersion()));
            props.add((Object)this.getText("admin.systeminfo.database.collation"), (Object)databaseMetaData.getCollation());
            if (this.featureManager.isEnabled(FeatureFlag.featureFlag((String)"jira.supportzip.database.latency").onByDefault())) {
                Duration latency = this.databaseLatencyMeter.measure();
                props.add((Object)this.getText("admin.systeminfo.database.latency.millis"), (Object)String.valueOf(latency.toMillis()));
                props.add((Object)this.getText("admin.systeminfo.database.latency.nanos"), (Object)String.valueOf(latency.toNanos()));
            }
        }
        catch (Exception e) {
            props.add((Object)this.getText("admin.systeminfo.database.accesserror"), (Object)e.toString());
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            props.add((Object)this.getText("admin.generalconfiguration.external.user.management"), (Object)(this.applicationProperties.getOption("jira.option.user.externalmanagement") ? this.getText("admin.common.words.on") : this.getText("admin.common.words.off")));
        }
        catch (Exception e) {
            log.error("Error getting the jira.option.user.externalmanagement application property: " + e, (Throwable)e);
            props.add((Object)this.getText("admin.generalconfiguration.external.user.management"), (Object)"ERROR");
        }
        props.add((Object)this.getText("admin.systeminfo.jvm.input.arguments"), (Object)this.systemInfoUtils.getJvmInputArguments());
        if (showSensitiveInfo) {
            String modifiedFilesDescription = this.getText("admin.systeminfo.modz.missing");
            String removedFilesDescription = this.getText("admin.systeminfo.modz.missing");
            try {
                Modifications modifications = this.registry.getModifications();
                modifiedFilesDescription = !modifications.modifiedFiles.isEmpty() ? StringUtils.join((Iterable)modifications.modifiedFiles, (String)", ") : this.getText("admin.systeminfo.modz.nomodifications");
                removedFilesDescription = !modifications.removedFiles.isEmpty() ? StringUtils.join((Iterable)modifications.removedFiles, (String)", ") : this.getText("admin.systeminfo.modz.noremovals");
            }
            catch (ModzRegistryException | RuntimeException e) {
                log.error(e.getMessage(), e);
            }
            String installType = "[" + this.getText("admin.systeminfo.installation.type") + ": " + this.systemInfoUtils.getInstallationType() + "] ";
            props.add((Object)this.getText("admin.systeminfo.modz.modified"), (Object)(installType + modifiedFilesDescription));
            props.add((Object)this.getText("admin.systeminfo.modz.removed"), (Object)(installType + removedFilesDescription));
        }
        props.add((Object)this.getText("admin.systeminfo.clustered"), (Object)(this.clusterManager.isClustered() ? this.getText("admin.common.words.on") : this.getText("admin.common.words.off")));
        if (this.clusterManager.isClustered()) {
            props.add((Object)this.getText("admin.systeminfo.clustered.node.id"), (Object)this.clusterManager.getNodeId());
        }
        return props.toListOrderedMap();
    }

    @Override
    public Map<String, String> getApplicationPropertiesFormatted(String suffix) {
        Map properties = this.applicationProperties.asMap();
        TreeMap props = new TreeMap();
        for (Map.Entry entry : properties.entrySet()) {
            boolean blacklist = false;
            for (Pattern rule : SECURITY_BLACKLISTED_PROPS) {
                if (!rule.matcher((CharSequence)entry.getKey()).matches()) continue;
                blacklist = true;
                break;
            }
            if (blacklist) continue;
            props.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return new LinkedHashMap<String, String>(props);
    }

    @Override
    public Map<String, String> getSystemPropertiesFormatted(String suffix) {
        Map sysProps = this.jiraSystemProperties.getSanitisedProperties();
        boolean isWindows = ((String)sysProps.get("os.name")).toLowerCase(Locale.ENGLISH).startsWith("windows");
        TreeMap<String, String> props = new TreeMap<String, String>();
        TreeMap<String, String> pathProps = new TreeMap<String, String>();
        for (Map.Entry entry : sysProps.entrySet()) {
            String propertyName = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (DEFAULT_PROPS.contains(propertyName)) continue;
            if (propertyName.endsWith(".path")) {
                String htmlValue = value;
                if (!isWindows) {
                    htmlValue = this.breakSeperators(htmlValue, ":", suffix);
                }
                pathProps.put(propertyName, this.breakSeperators(htmlValue, ";", suffix));
                continue;
            }
            props.put(propertyName, value);
        }
        LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
        propsMap.putAll(props);
        propsMap.putAll(pathProps);
        return propsMap;
    }

    private String breakSeperators(String input, String seperator, String suffix) {
        return input.replaceAll(seperator, seperator + suffix);
    }

    @Override
    public Map<String, String> getJvmStats() {
        MapBuilder jvmStats = MapBuilder.newBuilder();
        jvmStats.add((Object)this.getText("admin.systeminfo.total.memory"), (Object)(this.systemInfoUtils.getTotalMemory() + " MB"));
        jvmStats.add((Object)this.getText("admin.systeminfo.free.memory"), (Object)(this.systemInfoUtils.getFreeMemory() + " MB"));
        jvmStats.add((Object)this.getText("admin.systeminfo.used.memory"), (Object)(this.systemInfoUtils.getUsedMemory() + " MB"));
        if (this.isJvmWithPermGen()) {
            jvmStats.add((Object)this.getText("admin.systeminfo.total.perm.gen.memory"), (Object)(this.systemInfoUtils.getTotalPermGenMemory() + " MB"));
            jvmStats.add((Object)this.getText("admin.systeminfo.free.perm.gen.memory"), (Object)(this.systemInfoUtils.getFreePermGenMemory() + " MB"));
            jvmStats.add((Object)this.getText("admin.systeminfo.used.perm.gen.memory"), (Object)(this.systemInfoUtils.getUsedPermGenMemory() + " MB"));
        }
        return jvmStats.toListOrderedMap();
    }

    @Override
    public Map<String, String> getCommonConfigProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.getText("admin.config.allow.attachments"), String.valueOf(this.applicationProperties.getOption("jira.option.allowattachments")));
        map.put(this.getText("admin.config.allow.voting"), String.valueOf(this.applicationProperties.getOption("jira.option.voting")));
        map.put(this.getText("admin.config.allow.issue.watching"), String.valueOf(this.applicationProperties.getOption("jira.option.watching")));
        map.put(this.getText("admin.config.allow.unassigned"), String.valueOf(this.applicationProperties.getOption("jira.option.allowunassigned")));
        map.put(this.getText("admin.config.allow.subtasks"), String.valueOf(this.applicationProperties.getOption("jira.option.allowsubtasks")));
        map.put(this.getText("admin.config.allow.issue.linking"), String.valueOf(this.applicationProperties.getOption("jira.option.issuelinking")));
        map.put(this.getText("admin.config.timetracking.enabled"), String.valueOf(this.applicationProperties.getOption("jira.option.timetracking")));
        map.put(this.getText("admin.config.timetracking.hours.per.day"), this.applicationProperties.getDefaultBackedString("jira.timetracking.hours.per.day"));
        map.put(this.getText("admin.config.timetracking.days.per.week"), this.applicationProperties.getDefaultBackedString("jira.timetracking.days.per.week"));
        return map;
    }

    @Override
    public List<MemoryInformation> getMemoryPoolInformation() {
        return this.systemInfoUtils.getMemoryPoolInformation();
    }

    @Override
    public Map<String, String> getBuildStats() {
        MapBuilder buildstats = MapBuilder.newBuilder();
        buildstats.add((Object)this.getText("admin.systeminfo.uptime"), (Object)this.systemInfoUtils.getUptime(this.i18nHelper.getDefaultResourceBundle()));
        buildstats.add((Object)this.getText("admin.systeminfo.version"), (Object)this.buildUtilsInfo.getVersion());
        buildstats.add((Object)this.getText("admin.systeminfo.build.number"), (Object)this.buildUtilsInfo.getCurrentBuildNumber());
        buildstats.add((Object)this.getText("admin.systeminfo.build.date"), (Object)String.valueOf(this.buildUtilsInfo.getCurrentBuildDate()));
        buildstats.add((Object)this.getText("admin.systeminfo.build.revision"), (Object)String.valueOf(this.buildUtilsInfo.getCommitId()));
        buildstats.add((Object)this.getText("admin.license.partner.name"), (Object)this.buildUtilsInfo.getBuildPartnerName());
        buildstats.add((Object)this.getText("admin.systeminfo.installation.type"), (Object)this.systemInfoUtils.getInstallationType());
        buildstats.add((Object)this.getText("admin.server.id"), (Object)this.jiraLicenseServiceRef.map(JiraLicenseService::getServerId).orElse(""));
        List<UpgradeVersionHistoryItem> historyItems = this.getUpgradeHistory();
        if (!historyItems.isEmpty()) {
            UpgradeVersionHistoryItem lastUpgrade = historyItems.get(0);
            StringBuilder sb = new StringBuilder(this.getDateTimeFormatter().withStyle(DateTimeStyle.COMPLETE).format(lastUpgrade.getTimePerformed()));
            if (!StringUtils.isBlank((CharSequence)lastUpgrade.getOriginalVersion()) && !StringUtils.isBlank((CharSequence)lastUpgrade.getOriginalBuildNumber())) {
                String versionPriorToUpgrade = lastUpgrade.getOriginalVersion();
                String numberPriorToUpgrade = lastUpgrade.getOriginalBuildNumber();
                sb.append(String.format(" (v%s%s%s)", versionPriorToUpgrade, "#", numberPriorToUpgrade));
            }
            buildstats.add((Object)this.getText("admin.systeminfo.last.upgrade"), (Object)sb.toString());
        }
        return buildstats.toListOrderedMap();
    }

    @Override
    public List<UpgradeVersionHistoryItem> getUpgradeHistory() {
        return this.upgradeVersionHistoryManagerRef.map(UpgradeVersionHistoryReader::getAllUpgradeVersionHistory).orElseGet(ImmutableList::of);
    }

    @Override
    public String getDefaultLanguage() {
        return this.applicationProperties.getDefaultLocale().getDisplayName(this.i18nHelper.getLocale());
    }

    @Override
    public String getBaseUrl() {
        return this.applicationProperties.getDefaultBackedString("jira.baseurl");
    }

    @Override
    public boolean isUsingSystemLocale() {
        return this.localeManager.getLocale(this.applicationProperties.getDefaultBackedString("jira.i18n.default.locale")) == null;
    }

    @Override
    public Map<String, String> getUsageStats() {
        TreeMap<String, String> usageStats = new TreeMap<String, String>();
        try {
            boolean externalUserManagment = false;
            try {
                externalUserManagment = this.applicationProperties.getOption("jira.option.user.externalmanagement");
            }
            catch (Exception e) {
                log.error("Error reading jira.option.user.externalmanagement application property: " + e, (Throwable)e);
            }
            if (externalUserManagment) {
                usageStats.put(this.getText("admin.systeminfo.users"), this.ofBizDelegator.getCount("User") + " " + this.getText("admin.generalconfiguration.external.user.management.statistics"));
                usageStats.put(this.getText("admin.systeminfo.groups"), this.ofBizDelegator.getCount("Group") + " " + this.getText("admin.generalconfiguration.external.user.management.statistics"));
            } else {
                usageStats.put(this.getText("admin.systeminfo.users"), Long.toString(this.ofBizDelegator.getCount("User")));
                usageStats.put(this.getText("admin.systeminfo.groups"), Long.toString(this.ofBizDelegator.getCount("Group")));
            }
            usageStats.put(this.getText("admin.systeminfo.attachments"), Long.toString(this.ofBizDelegator.getCount("FileAttachment")));
            Map<String, Object> stats = this.jiraStartStopAnalyticHelper.getOnStartUsageStats(true);
            stats.entrySet().stream().filter(entry -> DB_STATS_WHITELIST.containsKey(entry.getKey())).forEach(entry -> usageStats.put(this.getText(DB_STATS_WHITELIST.get(entry.getKey())), String.valueOf(entry.getValue())));
        }
        catch (Exception e) {
            log.debug("Error while retrieving usage statistics", (Throwable)e);
            return ImmutableMap.of();
        }
        return Collections.unmodifiableMap(usageStats);
    }

    @Override
    public String getEntityEngineXmlPath() {
        try {
            return ClassLoaderUtils.getResource((String)"entityengine.xml", this.getClass()).toExternalForm();
        }
        catch (Exception e) {
            log.error("Could not load entityengine.xml path " + e.getMessage(), (Throwable)e);
            return "Could not load entityengine.xml  path.  Exception " + e.getMessage();
        }
    }

    @Override
    public String getLogPath() {
        String path;
        JiraLogLocator locator = (JiraLogLocator)ComponentAccessor.getComponent(JiraLogLocator.class);
        File logFile = locator.findJiraLogFile();
        if (logFile != null) {
            path = logFile.getAbsolutePath();
        } else {
            path = "Could not find atlassian-jira.log.";
            log.debug(path);
        }
        return path;
    }

    @Override
    public String getIndexLocation() {
        return ComponentAccessor.getIndexPathManager().getIndexRootPath();
    }

    @Override
    public String getAttachmentsLocation() {
        return ComponentAccessor.getAttachmentPathManager().getAttachmentPath();
    }

    @Override
    public String getBackupLocation() {
        FileStores fileStores = (FileStores)ComponentAccessor.getComponent(FileStores.class);
        try {
            return fileStores.getExportPath().asJavaFile().getPath();
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    @Override
    public String getJiraHomeLocation() {
        String path;
        FileStores fileStores = (FileStores)ComponentAccessor.getComponent(FileStores.class);
        try {
            path = fileStores.getHomeFilesystemPath().asJavaFile().getPath();
        }
        catch (IllegalStateException e) {
            path = "";
        }
        return path;
    }

    @Override
    public String getJiraLocalHomeLocation() {
        String path;
        FileStores fileStores = (FileStores)ComponentAccessor.getComponent(FileStores.class);
        try {
            path = fileStores.getLocalHomeFilesystemPath().asJavaFile().getPath();
        }
        catch (IllegalStateException e) {
            path = "";
        }
        return path;
    }

    @Override
    public Collection<GenericValue> getListeners() {
        TreeSet<GenericValue> listeners = new TreeSet<GenericValue>(COMPARE_BY_NAME);
        listeners.addAll(this.ofBizDelegator.findAll("ListenerConfig"));
        return listeners;
    }

    @Override
    public Collection<JiraServiceContainer> getServices() {
        TreeSet<JiraServiceContainer> services = new TreeSet<JiraServiceContainer>(JiraService.NAME_COMPARATOR);
        try {
            services.addAll(this.serviceManager.getServices());
        }
        catch (IllegalStateException ise) {
            log.debug("Cannot collect services info", (Throwable)ise);
        }
        return services;
    }

    @Override
    public Map<String, String> getServicePropertyMap(JiraServiceContainer serviceContainer) {
        try {
            return ConfigurableObjectUtil.getPropertyMap(serviceContainer);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getMillisecondsToMinutes(long ms) {
        return TimeUnit.MILLISECONDS.toMinutes(ms);
    }

    @Override
    public Collection<Plugin> getPlugins() {
        TreeSet<Plugin> plugins = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin plugin : this.pluginAccessor.getPlugins()) {
            if (plugins.add(plugin)) continue;
            throw new IllegalStateException("Multiple plugins with the same key and version:" + plugin.getKey() + " " + plugin.getPluginsVersion());
        }
        return Collections.unmodifiableSet(plugins);
    }

    @Override
    public boolean isPluginEnabled(Plugin plugin) {
        return this.pluginAccessor.isPluginEnabled(plugin.getKey());
    }

    @Override
    public Set<TrustedApplicationInfo> getTrustedApplications(JiraServiceContext jiraServiceContext) {
        TreeSet<TrustedApplicationInfo> trustedApplications = new TreeSet<TrustedApplicationInfo>(TrustedApplicationService.NAME_COMPARATOR);
        trustedApplications.addAll(this.trustedAppService.getAll(jiraServiceContext));
        return trustedApplications;
    }

    @Override
    public Set<String> getIPMatches(TrustedApplicationInfo info) {
        return TrustedApplicationUtil.getLines(info.getIpMatch());
    }

    @Override
    public Set<String> getUrlMatches(TrustedApplicationInfo info) {
        return TrustedApplicationUtil.getLines(info.getUrlMatch());
    }

    @Override
    public boolean isJvmWithPermGen() {
        return this.systemInfoUtils.getTotalPermGenMemory() > 0L;
    }

    private DateTimeFormatter getDateTimeFormatter() {
        return ((DateTimeFormatterFactory)ComponentAccessor.getComponent(DateTimeFormatterFactory.class)).formatter().withLocale(this.i18nHelper.getLocale());
    }

    private String getText(String key) {
        return this.i18nHelper.getText(key);
    }

    private String getText(String key, String value1) {
        return this.i18nHelper.getText(key, value1);
    }

    @Override
    public boolean isClustered() {
        return this.clusterManager.isClustered();
    }

    @Override
    public Map<Node, Boolean> getClusterNodeInformation() {
        if (!this.clusterManager.isClustered()) {
            return ImmutableMap.of();
        }
        Set liveNodes = this.clusterManager.findLiveNodes().stream().map(Node::getNodeId).collect(Collectors.toSet());
        ImmutableMap.Builder nodeMap = ImmutableMap.builder();
        this.clusterManager.getAllNodes().forEach(node -> nodeMap.put(node, (Object)liveNodes.contains(node.getNodeId())));
        return nodeMap.build();
    }

    private static List<Pattern> compile(String ... regexes) {
        return (List)Arrays.asList(regexes).stream().map(Pattern::compile).collect(CollectorsUtil.toImmutableList());
    }
}

